/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractHtmlAdapter {
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    protected static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    protected static final DateTimeFormatter DATE_TIME_DISPLAY_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");

    protected String format(Date date, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        if (date == null) {
            return "";
        }
        return formatter.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    protected String formatLastUpdated(Resource resource, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasLastUpdated()) {
            return "";
        }
        return this.format(resource.getMeta().getLastUpdated(), formatter);
    }
}

