package dev.dsf.fhir.search.parameters;

import org.hl7.fhir.r4.model.Enumerations.SearchParamType;
import org.hl7.fhir.r4.model.ValueSet;

import dev.dsf.fhir.search.SearchQueryParameter.SearchParameterDefinition;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;

@SearchParameterDefinition(name = AbstractIdentifierParameter.PARAMETER_NAME, definition = "http://hl7.org/fhir/SearchParameter/conformance-identifier", type = SearchParamType.TOKEN, documentation = "External identifier for the value set")
public class ValueSetIdentifier extends AbstractIdentifierParameter<ValueSet>
{
	public ValueSetIdentifier()
	{
		super(ValueSet.class, "value_set", listMatcher(ValueSet::hasIdentifier, ValueSet::getIdentifier));
	}
}
