/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.secure;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.webservice.base.AbstractDelegatingBasicService;
import dev.dsf.fhir.webservice.base.BasicService;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractServiceSecure<S extends BasicService>
extends AbstractDelegatingBasicService<S>
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceSecure.class);
    protected static final Logger audit = LoggerFactory.getLogger((String)"dsf-audit-logger");
    protected final String serverBase;
    protected final ResponseGenerator responseGenerator;
    protected final ReferenceResolver referenceResolver;

    public AbstractServiceSecure(S delegate, String serverBase, ResponseGenerator responseGenerator, ReferenceResolver referenceResolver) {
        super(delegate);
        this.serverBase = serverBase;
        this.referenceResolver = referenceResolver;
        this.responseGenerator = responseGenerator;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.referenceResolver, "referenceResolver");
    }

    protected final Response forbidden(String operation) {
        return this.responseGenerator.forbiddenNotAllowed(operation, this.currentIdentityProvider.getCurrentIdentity());
    }

    protected void logCurrentIdentity() {
        Identity identity = this.getCurrentIdentity();
        if (identity instanceof OrganizationIdentity) {
            logger.debug("Current organization identity '{}', dsf-roles '{}'", (Object)identity.getName(), (Object)identity.getDsfRoles());
        } else if (identity instanceof PractitionerIdentity) {
            PractitionerIdentity practitionerIdentity = (PractitionerIdentity)identity;
            logger.debug("Current practitioner identity '{}', dsf-roles '{}', practitioner-roles '{}'", new Object[]{identity.getName(), identity.getDsfRoles(), practitionerIdentity.getPractionerRoles().stream().map(c -> c.getSystem() + "|" + c.getCode()).collect(Collectors.joining(", ", "[", "]"))});
        }
    }
}

