/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;

@Provider
public class BrowserPolicyHeaderResponseFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getAcceptableMediaTypes() != null && requestContext.getAcceptableMediaTypes().contains(MediaType.TEXT_HTML_TYPE) || requestContext.getUriInfo() != null && requestContext.getUriInfo().getPath() != null && requestContext.getUriInfo().getPath().startsWith("static/")) {
            MultivaluedMap headers = responseContext.getHeaders();
            headers.add((Object)"X-Content-Type-Options", (Object)"nosniff");
            headers.add((Object)"Referrer-Policy", (Object)"strict-origin-when-cross-origin");
            headers.add((Object)"Cross-Origin-Opener-Policy", (Object)"same-origin");
            headers.add((Object)"Cross-Origin-Embedder-Policy", (Object)"require-corp");
            headers.add((Object)"Cross-Origin-Resource-Policy", (Object)"same-site");
            headers.add((Object)"Permissions-Policy", (Object)"geolocation=(), camera=(), microphone=()");
            if (requestContext.getUriInfo() != null && requestContext.getUriInfo().getPath() != null && requestContext.getUriInfo().getPath().startsWith("Binary/")) {
                headers.add((Object)"Content-Security-Policy", (Object)"base-uri 'self'; frame-ancestors 'none'; form-action 'self'; default-src 'none'; connect-src 'self'; img-src 'self'; script-src 'self' 'unsafe-inline'; style-src 'self' 'unsafe-inline'");
            } else {
                headers.add((Object)"Content-Security-Policy", (Object)"base-uri 'self'; frame-ancestors 'none'; form-action 'self'; default-src 'none'; connect-src 'self'; img-src 'self'; script-src 'self'; style-src 'self'");
            }
        }
    }
}

