/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import ca.uhn.fhir.parser.IParser;
import dev.dsf.fhir.service.InitialDataLoader;
import dev.dsf.fhir.service.InitialDataLoaderImpl;
import dev.dsf.fhir.spring.config.CommandConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import dev.dsf.fhir.spring.config.ReferenceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
public class InitialDataLoaderConfig {
    private static final Logger logger = LoggerFactory.getLogger(InitialDataLoaderConfig.class);
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private CommandConfig commandConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private ReferenceConfig referenceConfig;

    @Bean
    public InitialDataLoader initialDataLoader() {
        return new InitialDataLoaderImpl(this.commandConfig.commandFactory(), this.fhirConfig.fhirContext());
    }

    @Order(value=-2147483648)
    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent(ContextRefreshedEvent event) throws IOException {
        try (InputStream fileIn = ClassLoader.getSystemResourceAsStream("fhir/bundle.xml");){
            logger.info("Loading data from JAR bundle ...");
            Bundle bundle = this.parseXmlBundle(p -> (Bundle)p.parseResource(Bundle.class, fileIn));
            this.initialDataLoader().load(bundle);
        }
        catch (Exception e) {
            logger.warn("Error while loading data from JAR bundle: {}", (Object)e.getMessage());
            throw e;
        }
        Path file = Paths.get(this.propertiesConfig.getInitBundleFile(), new String[0]);
        if (!Files.isReadable(file)) {
            throw new IOException("Init bundle file at " + file.toString() + " not readable");
        }
        try (InputStream fileIn = Files.newInputStream(file, new OpenOption[0]);){
            String read = IOUtils.toString((InputStream)fileIn, (Charset)StandardCharsets.UTF_8);
            String resolved = event.getApplicationContext().getEnvironment().resolveRequiredPlaceholders(read);
            logger.info("Loading data from external bundle ...");
            Bundle bundle = this.parseXmlBundle(p -> (Bundle)p.parseResource(Bundle.class, resolved));
            this.initialDataLoader().load(bundle);
        }
        catch (Exception e) {
            logger.warn("Error while loading data from external bundle: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private Bundle parseXmlBundle(Function<IParser, Bundle> parse) {
        IParser p = this.fhirConfig.fhirContext().newXmlParser();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        Bundle bundle = parse.apply(p);
        return (Bundle)this.referenceConfig.referenceCleaner().cleanReferenceResourcesIfBundle((Resource)bundle);
    }
}

