/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.SearchQuerySortParameterConfiguration;
import dev.dsf.fhir.search.parameters.SearchQuerySortParameter;
import java.util.List;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractSearchParameter<R extends Resource>
implements SearchQueryParameter<R>,
SearchQuerySortParameter {
    protected final String parameterName;

    public AbstractSearchParameter(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public final String getParameterName() {
        return this.parameterName;
    }

    protected final IllegalStateException notDefined() {
        return new IllegalStateException("not defined");
    }

    @Override
    public SearchQueryParameter<R> configure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        this.doConfigure(errors, queryParameterName, queryParameterValue);
        return this;
    }

    protected abstract void doConfigure(List<? super SearchQueryParameterError> var1, String var2, String var3);

    @Override
    public SearchQuerySortParameterConfiguration configureSort(List<? super SearchQueryParameterError> errors, String queryParameterSortValue) {
        SearchQuerySortParameterConfiguration.SortDirection direction = SearchQuerySortParameterConfiguration.SortDirection.fromString(queryParameterSortValue);
        return new SearchQuerySortParameterConfiguration(this.getSortSql(direction.getSqlModifierWithSpacePrefix()), this.parameterName, direction);
    }

    protected abstract String getSortSql(String var1);
}

