/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractIdentifierParameter<R extends Resource>
extends AbstractTokenParameter<R> {
    public static final String PARAMETER_NAME = "identifier";
    private final String resourceColumn;

    public AbstractIdentifierParameter(String resourceColumn) {
        super(PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case CODE: 
            case CODE_AND_SYSTEM: 
            case SYSTEM: {
                if (this.valueAndType.negated) {
                    return "NOT (" + this.resourceColumn + "->'identifier' @> ?::jsonb)";
                }
                return this.resourceColumn + "->'identifier' @> ?::jsonb";
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                if (this.valueAndType.negated) {
                    return "(SELECT count(*) FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier WHERE identifier->>'value' <> ? OR (identifier ?? 'system')) > 0";
                }
                return "(SELECT count(*) FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.codeValue + "\"}]");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
        }
    }

    protected final boolean identifierMatches(List<Identifier> identifiers) {
        return identifiers.stream().anyMatch(i -> this.valueAndType.negated ? !AbstractIdentifierParameter.identifierMatches(this.valueAndType, i) : AbstractIdentifierParameter.identifierMatches(this.valueAndType, i));
    }

    public static boolean identifierMatches(TokenValueAndSearchType valueAndType, Identifier identifier) {
        switch (valueAndType.type) {
            case CODE: {
                return Objects.equals(valueAndType.codeValue, identifier.getValue());
            }
            case CODE_AND_SYSTEM: {
                return Objects.equals(valueAndType.codeValue, identifier.getValue()) && Objects.equals(valueAndType.systemValue, identifier.getSystem());
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                return Objects.equals(valueAndType.codeValue, identifier.getValue()) && (identifier.getSystem() == null || identifier.getSystem().isBlank());
            }
            case SYSTEM: {
                return Objects.equals(valueAndType.systemValue, identifier.getSystem());
            }
        }
        return false;
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT string_agg((identifier->>'system')::text || (identifier->>'value')::text, ' ') FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier)" + sortDirectionWithSpacePrefix;
    }
}

