/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import java.util.List;
import org.hl7.fhir.r4.model.DomainResource;

public abstract class AbstractBooleanParameter<R extends DomainResource>
extends AbstractSearchParameter<R> {
    protected Boolean value;

    public AbstractBooleanParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    public void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        if (queryParameterValue != null && !queryParameterValue.isEmpty()) {
            switch (queryParameterValue) {
                case "true": {
                    this.value = true;
                    break;
                }
                case "false": {
                    this.value = false;
                    break;
                }
                default: {
                    this.value = null;
                    errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue, "true or false expected"));
                }
            }
        }
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return this.parameterName;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return String.valueOf(this.value);
    }
}

