/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Subscription;

@SearchQueryParameter.SearchParameterDefinition(name="payload", definition="http://hl7.org/fhir/SearchParameter/Subscription-payload", type=Enumerations.SearchParamType.TOKEN, documentation="The mime-type of the notification payload")
public class SubscriptionPayload
extends AbstractTokenParameter<Subscription> {
    public static final String PARAMETER_NAME = "payload";
    public static final String RESOURCE_COLUMN = "subscription";
    private String payloadMimeType;

    public SubscriptionPayload() {
        super(PARAMETER_NAME);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.payloadMimeType = this.valueAndType.codeValue;
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.payloadMimeType != null;
    }

    @Override
    public String getFilterQuery() {
        return "subscription->'channel'->>'payload' " + (this.valueAndType.negated ? "<>" : "=") + " ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.payloadMimeType);
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.payloadMimeType;
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Subscription)) {
            return false;
        }
        if (this.valueAndType.negated) {
            return !Objects.equals(((Subscription)resource).getChannel().getPayload(), this.payloadMimeType);
        }
        return Objects.equals(((Subscription)resource).getChannel().getPayload(), this.payloadMimeType);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "subscription->'channel'->>'payload'" + sortDirectionWithSpacePrefix;
    }
}

