/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;

@IncludeParameterDefinition(resourceType=ResearchStudy.class, parameterName="principalinvestigator", targetResourceTypes={Practitioner.class, PractitionerRole.class})
@SearchQueryParameter.SearchParameterDefinition(name="principalinvestigator", definition="http://hl7.org/fhir/SearchParameter/ResearchStudy-principalinvestigator", type=Enumerations.SearchParamType.REFERENCE, documentation="Researcher who oversees multiple aspects of the study")
public class ResearchStudyPrincipalInvestigator
extends AbstractReferenceParameter<ResearchStudy> {
    public static final String RESOURCE_TYPE_NAME = "ResearchStudy";
    public static final String PARAMETER_NAME = "principalinvestigator";
    public static final String[] TARGET_RESOURCE_TYPE_NAMES = new String[]{"Practitioner", "PractitionerRole"};
    private static final String IDENTIFIERS_SUBQUERY = "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = research_study->'principalInvestigator'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = research_study->'principalInvestigator'->>'reference')";

    public static List<String> getIncludeParameterValues() {
        return Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).map(target -> "ResearchStudy:principalinvestigator:" + target).toList();
    }

    public ResearchStudyPrincipalInvestigator() {
        super(ResearchStudy.class, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAMES);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case ID: {
                return "research_study->'principalInvestigator'->>'reference' = ANY (?)";
            }
            case RESOURCE_NAME_AND_ID: 
            case URL: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                return "research_study->'principalInvestigator'->>'reference' = ?";
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: 
                    case CODE_AND_SYSTEM: 
                    case SYSTEM: {
                        return "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = research_study->'principalInvestigator'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = research_study->'principalInvestigator'->>'reference') @> ?::jsonb";
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        return "(SELECT count(*) FROM jsonb_array_elements((SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = research_study->'principalInvestigator'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = research_study->'principalInvestigator'->>'reference')) identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
                    }
                }
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        block0 : switch (this.valueAndType.type) {
            case ID: {
                Array array = arrayCreator.apply("TEXT", Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).map(n -> n + "/" + this.valueAndType.id).toArray());
                statement.setArray(parameterIndex, array);
                break;
            }
            case RESOURCE_NAME_AND_ID: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                statement.setString(parameterIndex, this.valueAndType.resourceName + "/" + this.valueAndType.id);
                break;
            }
            case URL: {
                statement.setString(parameterIndex, this.valueAndType.url);
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\", \"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        statement.setString(parameterIndex, this.valueAndType.identifier.codeValue);
                        break block0;
                    }
                    case SYSTEM: {
                        statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                    }
                }
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(ResearchStudy resource, DaoProvider daoProvider) throws SQLException {
        Reference reference = resource.getPrincipalInvestigator();
        IIdType idType = reference.getReferenceElement();
        if (idType.hasResourceType()) {
            if ("Practitioner".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getPractitionerDao());
            } else if ("PractitionerRole".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getPractitionerRoleDao());
            }
        }
    }

    private void setResource(Reference reference, IIdType idType, ResourceDao<?> dao) throws SQLException {
        try {
            if (idType.hasVersionIdPart()) {
                dao.readVersion(UUID.fromString(idType.getIdPart()), idType.getVersionIdPartAsLong()).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            } else {
                dao.read(UUID.fromString(idType.getIdPart())).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            }
        }
        catch (ResourceDeletedException resourceDeletedException) {
            // empty catch block
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy r = (ResearchStudy)resource;
        if (AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER.equals((Object)this.valueAndType.type)) {
            if (r.getPrincipalInvestigator().getResource() instanceof Practitioner) {
                Practitioner p = (Practitioner)r.getPrincipalInvestigator().getResource();
                return p.getIdentifier().stream().anyMatch(i -> AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier, i));
            }
            if (r.getPrincipalInvestigator().getResource() instanceof PractitionerRole) {
                PractitionerRole p = (PractitionerRole)r.getPrincipalInvestigator().getResource();
                return p.getIdentifier().stream().anyMatch(i -> AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier, i));
            }
            return false;
        }
        String ref = r.getPrincipalInvestigator().getReference();
        switch (this.valueAndType.type) {
            case ID: {
                return ref.equals("Practitioner/" + this.valueAndType.id) || ref.equals("PractitionerRole/" + this.valueAndType.id);
            }
            case RESOURCE_NAME_AND_ID: {
                return ref.equals(this.valueAndType.resourceName + "/" + this.valueAndType.id);
            }
            case URL: {
                return ref.equals(this.valueAndType.url);
            }
        }
        return false;
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "research_study->'principalInvestigator'->>'reference'";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (RESOURCE_TYPE_NAME.equals(includeParts.getSourceResourceTypeName()) && PARAMETER_NAME.equals(includeParts.getSearchParameterName()) && Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).anyMatch(n -> n.equals(includeParts.getTargetResourceTypeName()))) {
            switch (includeParts.getTargetResourceTypeName()) {
                case "Practitioner": {
                    return "(SELECT jsonb_build_array(practitioner) FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = research_study->'principalInvestigator'->>'reference') AS practitioners";
                }
                case "PractitionerRole": {
                    return "(SELECT jsonb_build_array(practitioner_role) FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = research_study->'principalInvestigator'->>'reference') AS practitioner_roles";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

