/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="The unique identifier for the questionnaire response")
public class QuestionnaireResponseIdentifier
extends AbstractIdentifierParameter<QuestionnaireResponse> {
    public static final String RESOURCE_COLUMN = "questionnaire_response";

    public QuestionnaireResponseIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case CODE: 
            case CODE_AND_SYSTEM: 
            case SYSTEM: {
                return "questionnaire_response->'identifier' " + (this.valueAndType.negated ? "<>" : "=") + " ?::jsonb";
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                if (this.valueAndType.negated) {
                    return "questionnaire_response->'identifier'->>'value' <> ? OR (questionnaire_response->'identifier' ?? 'system')";
                }
                return "questionnaire_response->'identifier'->>'value' = ? AND NOT (questionnaire_response->'identifier' ?? 'system')";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\"}");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "{\"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
        }
    }

    private boolean identifierMatches(Identifier identifier) {
        if (this.valueAndType.negated) {
            return !AbstractIdentifierParameter.identifierMatches(this.valueAndType, identifier);
        }
        return AbstractIdentifierParameter.identifierMatches(this.valueAndType, identifier);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(questionnaire_response->'identifier'->>'system')::text || (questionnaire_response->'identifier'->>'value')::text" + sortDirectionWithSpacePrefix;
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse qr = (QuestionnaireResponse)resource;
        return this.identifierMatches(qr.getIdentifier());
    }
}

