/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractBooleanParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="active", definition="http://hl7.org/fhir/SearchParameter/Patient-active", type=Enumerations.SearchParamType.TOKEN, documentation="Whether the patient record is active [true|false]")
public class PatientActive
extends AbstractBooleanParameter<Patient> {
    public static final String PARAMETER_NAME = "active";

    public PatientActive() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        return "(patient->>'active')::BOOLEAN = ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setBoolean(parameterIndex, this.value);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Patient)) {
            return false;
        }
        Patient p = (Patient)resource;
        return p.getActive() == this.value.booleanValue();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(patient->>'active')::BOOLEAN" + sortDirectionWithSpacePrefix;
    }
}

