/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/OrganizationAffiliation-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="An organization affiliation's Identifier")
public class OrganizationAffiliationIdentifier
extends AbstractIdentifierParameter<OrganizationAffiliation> {
    public static final String RESOURCE_COLUMN = "organization_affiliation";

    public OrganizationAffiliationIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof OrganizationAffiliation)) {
            return false;
        }
        OrganizationAffiliation o = (OrganizationAffiliation)resource;
        return this.identifierMatches(o.getIdentifier());
    }
}

