/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/MeasureReport-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier of the measure report to be returned")
public class MeasureReportIdentifier
extends AbstractIdentifierParameter<MeasureReport> {
    public static final String RESOURCE_COLUMN = "measure_report";

    public MeasureReportIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof MeasureReport)) {
            return false;
        }
        MeasureReport m = (MeasureReport)resource;
        return this.identifierMatches(m.getIdentifier());
    }
}

