/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Measure-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the measure")
public class MeasureIdentifier
extends AbstractIdentifierParameter<Measure> {
    public static final String RESOURCE_COLUMN = "measure";

    public MeasureIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Measure)) {
            return false;
        }
        Measure m = (Measure)resource;
        return this.identifierMatches(m.getIdentifier());
    }
}

