/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import dev.dsf.fhir.search.SearchQueryRevIncludeParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class SearchQueryRevIncludeParameterFactory {
    private final Supplier<SearchQueryRevIncludeParameter> revIncludeSupplier;
    private final List<String> revIncludeParameterValues = new ArrayList<String>();

    public SearchQueryRevIncludeParameterFactory(Supplier<SearchQueryRevIncludeParameter> revIncludeSupplier, List<String> revIncludeParameterValues) {
        this.revIncludeSupplier = revIncludeSupplier;
        if (revIncludeParameterValues != null) {
            this.revIncludeParameterValues.addAll(revIncludeParameterValues);
        }
        if (revIncludeSupplier != null ^ revIncludeParameterValues != null) {
            throw new IllegalArgumentException("includeSupplier and includeParameterValues must both be null or not null");
        }
    }

    public Stream<String> getRevIncludeParameterValues() {
        return this.revIncludeParameterValues.stream();
    }

    public boolean isIncludeParameter() {
        return this.revIncludeSupplier != null && this.revIncludeParameterValues != null;
    }

    public SearchQueryRevIncludeParameter createQueryRevIncludeParameter() {
        return this.revIncludeSupplier.get();
    }
}

