/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import dev.dsf.fhir.function.BiConsumerWithSqlException;
import dev.dsf.fhir.search.IncludeParts;
import java.sql.Connection;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Resource;

public class SearchQueryIncludeParameterConfiguration {
    private final String sql;
    private final IncludeParts includeParts;
    private final BiConsumerWithSqlException<Resource, Connection> includeResourceModifier;

    public SearchQueryIncludeParameterConfiguration(String sql, IncludeParts includeParts) {
        this(sql, includeParts, null);
    }

    public SearchQueryIncludeParameterConfiguration(String sql, IncludeParts includeParts, BiConsumerWithSqlException<Resource, Connection> includeResourceModifier) {
        this.sql = sql;
        this.includeParts = includeParts;
        this.includeResourceModifier = includeResourceModifier;
    }

    public String getBundleUriQueryParameterValues() {
        return this.includeParts.toBundleUriQueryParameterValue();
    }

    public String getSql() {
        return this.sql;
    }

    public void modifyIncludeResource(Resource resource, Connection connection) throws SQLException {
        if (this.includeResourceModifier != null) {
            this.includeResourceModifier.accept(resource, connection);
        }
    }
}

