/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

public class IncludeParts {
    private final String sourceResourceTypeName;
    private final String searchParameterName;
    private final String targetResourceTypeName;

    public IncludeParts(String sourceResourceTypeName, String searchParameterName, String targetResourceTypeName) {
        this.sourceResourceTypeName = sourceResourceTypeName;
        this.searchParameterName = searchParameterName;
        this.targetResourceTypeName = targetResourceTypeName;
    }

    public static IncludeParts fromString(String includeParameterValue) {
        if (includeParameterValue == null || includeParameterValue.isBlank()) {
            return new IncludeParts(null, null, null);
        }
        String[] parts = includeParameterValue.split(":");
        String sourceResourceTypeName = null;
        String searchParameterName = null;
        String targetResourceTypeName = null;
        if (parts.length > 0) {
            sourceResourceTypeName = parts[0];
        }
        if (parts.length > 1) {
            searchParameterName = parts[1];
        }
        if (parts.length > 2) {
            targetResourceTypeName = parts[2];
        }
        return new IncludeParts(sourceResourceTypeName, searchParameterName, targetResourceTypeName);
    }

    public String toBundleUriQueryParameterValue() {
        return this.getSourceResourceTypeName() + ":" + this.getSearchParameterName() + (String)(this.getTargetResourceTypeName() != null ? ":" + this.getTargetResourceTypeName() : "");
    }

    public String getSourceResourceTypeName() {
        return this.sourceResourceTypeName;
    }

    public String getSearchParameterName() {
        return this.searchParameterName;
    }

    public String getTargetResourceTypeName() {
        return this.targetResourceTypeName;
    }

    public boolean matches(String resourceTypeName, String parameterName, String targetResourceTypeName) {
        return resourceTypeName.equals(this.getSourceResourceTypeName()) && parameterName.equals(this.getSearchParameterName()) && (this.getTargetResourceTypeName() == null || targetResourceTypeName.equals(this.getTargetResourceTypeName()));
    }

    public String toString() {
        if (this.searchParameterName == null && this.targetResourceTypeName == null) {
            return this.sourceResourceTypeName;
        }
        if (this.targetResourceTypeName == null) {
            return this.sourceResourceTypeName + ":" + this.searchParameterName;
        }
        return this.sourceResourceTypeName + ":" + this.searchParameterName + ":" + this.targetResourceTypeName;
    }
}

