/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.fhir.dao.jdbc.PreparedStatementFactory;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.postgresql.util.PGobject;

abstract class AbstractPreparedStatementFactory<R extends Resource>
implements PreparedStatementFactory<R> {
    private final FhirContext fhirContext;
    private final Class<R> resourceType;
    private final String createSql;
    private final String readByIdSql;
    private final String readByIdAndVersionSql;
    private final String updateNewRowSql;
    private final String updateSameRowSql;

    protected AbstractPreparedStatementFactory(FhirContext fhirContext, Class<R> resourceType, String createSql, String readByIdSql, String readByIdAndVersionSql, String updateNewRowSql, String updateSameRowSql) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
        this.createSql = Objects.requireNonNull(createSql, "createSql");
        this.readByIdSql = Objects.requireNonNull(readByIdSql, "readByIdSql");
        this.readByIdAndVersionSql = Objects.requireNonNull(readByIdAndVersionSql, "readByIdAndVersionSql");
        this.updateNewRowSql = Objects.requireNonNull(updateNewRowSql, "updateNewRowSql");
        this.updateSameRowSql = Objects.requireNonNull(updateSameRowSql, "updateSameRowSql");
    }

    @Override
    public IParser getJsonParser() {
        IParser p = this.fhirContext.newJsonParser();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        return p;
    }

    protected final R jsonToResource(String json) {
        Resource resource = (Resource)this.getJsonParser().parseResource(this.resourceType, json);
        if (!(resource instanceof DomainResource)) {
            IdType fixedId = new IdType(resource.getResourceType().name(), resource.getIdElement().getIdPart(), resource.getMeta().getVersionId());
            resource.setIdElement(fixedId);
        }
        return (R)resource;
    }

    @Override
    public final PGobject resourceToPgObject(R resource) {
        if (resource == null) {
            return null;
        }
        try {
            PGobject o = new PGobject();
            o.setType("JSONB");
            o.setValue(this.getJsonParser().encodeResourceToString(resource));
            return o;
        }
        catch (DataFormatException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final PGobject uuidToPgObject(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            PGobject o = new PGobject();
            o.setType("UUID");
            o.setValue(uuid.toString());
            return o;
        }
        catch (DataFormatException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final String getCreateSql() {
        return this.createSql;
    }

    @Override
    public final String getReadByIdSql() {
        return this.readByIdSql;
    }

    @Override
    public final String getReadByIdAndVersionSql() {
        return this.readByIdAndVersionSql;
    }

    @Override
    public final String getUpdateNewRowSql() {
        return this.updateNewRowSql;
    }

    @Override
    public final String getUpdateSameRowSql() {
        return this.updateSameRowSql;
    }
}

