/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.BatchCommandList;
import dev.dsf.fhir.dao.command.CheckReferencesCommand;
import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.CommandFactory;
import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.dao.command.CreateCommand;
import dev.dsf.fhir.dao.command.CreateStructureDefinitionCommand;
import dev.dsf.fhir.dao.command.DeleteCommand;
import dev.dsf.fhir.dao.command.DeleteStructureDefinitionCommand;
import dev.dsf.fhir.dao.command.HeadCommand;
import dev.dsf.fhir.dao.command.ReadCommand;
import dev.dsf.fhir.dao.command.TransactionCommandList;
import dev.dsf.fhir.dao.command.TransactionResources;
import dev.dsf.fhir.dao.command.UpdateCommand;
import dev.dsf.fhir.dao.command.UpdateStructureDefinitionCommand;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.exception.BadBundleException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.validation.SnapshotGenerator;
import java.sql.Connection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.springframework.beans.factory.InitializingBean;

public class CommandFactoryImpl
implements InitializingBean,
CommandFactory {
    private final String serverBase;
    private final int defaultPageCount;
    private final DataSource dataSource;
    private final DaoProvider daoProvider;
    private final ReferenceExtractor referenceExtractor;
    private final ReferenceResolver referenceResolver;
    private final ReferenceCleaner referenceCleaner;
    private final ResponseGenerator responseGenerator;
    private final ExceptionHandler exceptionHandler;
    private final ParameterConverter parameterConverter;
    private final EventHandler eventHandler;
    private final EventGenerator eventGenerator;
    private final AuthorizationHelper authorizationHelper;
    private final ValidationHelper validationHelper;
    private final SnapshotGenerator snapshotGenerator;
    private final Function<Connection, TransactionResources> transactionResourcesFactory;

    public CommandFactoryImpl(String serverBase, int defaultPageCount, DataSource dataSource, DaoProvider daoProvider, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, ResponseGenerator responseGenerator, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, EventHandler eventHandler, EventGenerator eventGenerator, AuthorizationHelper authorizationHelper, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator, Function<Connection, TransactionResources> transactionResourcesFactory) {
        this.serverBase = serverBase;
        this.defaultPageCount = defaultPageCount;
        this.dataSource = dataSource;
        this.daoProvider = daoProvider;
        this.referenceExtractor = referenceExtractor;
        this.referenceResolver = referenceResolver;
        this.referenceCleaner = referenceCleaner;
        this.responseGenerator = responseGenerator;
        this.exceptionHandler = exceptionHandler;
        this.parameterConverter = parameterConverter;
        this.eventHandler = eventHandler;
        this.eventGenerator = eventGenerator;
        this.authorizationHelper = authorizationHelper;
        this.validationHelper = validationHelper;
        this.snapshotGenerator = snapshotGenerator;
        this.transactionResourcesFactory = transactionResourcesFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.dataSource, "dataSource");
        Objects.requireNonNull(this.daoProvider, "daoProvider");
        Objects.requireNonNull(this.referenceExtractor, "referenceExtractor");
        Objects.requireNonNull(this.referenceResolver, "referenceResolver");
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.eventHandler, "eventHandler");
        Objects.requireNonNull(this.eventGenerator, "eventGenerator");
        Objects.requireNonNull(this.authorizationHelper, "authorizationHelper");
        Objects.requireNonNull(this.validationHelper, "validationHelper");
        Objects.requireNonNull(this.snapshotGenerator, "snapshotGenerator");
        Objects.requireNonNull(this.transactionResourcesFactory, "transactionResourcesFactory");
    }

    private Command head(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, PreferHandlingType handlingType) {
        return new HeadCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, this.defaultPageCount, this.daoProvider, this.parameterConverter, this.responseGenerator, this.exceptionHandler, this.referenceCleaner, handlingType);
    }

    private Command get(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, PreferHandlingType handlingType) {
        return new ReadCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, this.defaultPageCount, this.daoProvider, this.parameterConverter, this.responseGenerator, this.exceptionHandler, this.referenceCleaner, handlingType);
    }

    private <R extends Resource> Command post(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, R resource) {
        if (resource.getResourceType().name().equals(entry.getRequest().getUrl())) {
            Optional<ResourceDao<?>> dao = this.daoProvider.getDao(resource.getClass());
            if (resource instanceof StructureDefinition) {
                return new CreateStructureDefinitionCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, (StructureDefinition)resource, (StructureDefinitionDao)dao.get(), this.exceptionHandler, this.parameterConverter, this.responseGenerator, this.referenceExtractor, this.referenceResolver, this.referenceCleaner, this.eventGenerator, this.daoProvider.getStructureDefinitionSnapshotDao());
            }
            return dao.map(d -> new CreateCommand<Resource, ResourceDao>(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, resource, (ResourceDao)d, this.exceptionHandler, this.parameterConverter, this.responseGenerator, this.referenceExtractor, this.referenceResolver, this.referenceCleaner, this.eventGenerator)).orElseThrow(() -> new IllegalStateException("Resource of type " + resource.getClass().getName() + " not supported"));
        }
        throw new IllegalStateException("Request url " + entry.getRequest().getUrl() + " for method POST not supported");
    }

    private <R extends Resource> Command put(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, R resource) {
        if (entry.getRequest().getUrl() != null && !entry.getRequest().getUrl().isBlank() && entry.getRequest().getUrl().startsWith(resource.getResourceType().name())) {
            Optional<ResourceDao<?>> dao = this.daoProvider.getDao(resource.getClass());
            if (resource instanceof StructureDefinition) {
                return new UpdateStructureDefinitionCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, (StructureDefinition)resource, (StructureDefinitionDao)dao.get(), this.exceptionHandler, this.parameterConverter, this.responseGenerator, this.referenceExtractor, this.referenceResolver, this.referenceCleaner, this.eventGenerator, this.daoProvider.getStructureDefinitionSnapshotDao());
            }
            return dao.map(d -> new UpdateCommand<Resource, ResourceDao>(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, resource, (ResourceDao)d, this.exceptionHandler, this.parameterConverter, this.responseGenerator, this.referenceExtractor, this.referenceResolver, this.referenceCleaner, this.eventGenerator)).orElseThrow(() -> new IllegalStateException("Resource of type " + resource.getClass().getName() + " not supported"));
        }
        throw new IllegalStateException("Request url " + entry.getRequest().getUrl() + " for method POST not supported");
    }

    private Command delete(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry) {
        if (entry.getRequest().getUrl() != null && !entry.getRequest().getUrl().isBlank()) {
            if (entry.getRequest().getUrl().startsWith("StructureDefinition")) {
                return new DeleteStructureDefinitionCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, this.responseGenerator, this.daoProvider, this.exceptionHandler, this.parameterConverter, this.eventGenerator);
            }
            return new DeleteCommand(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, this.responseGenerator, this.daoProvider, this.exceptionHandler, this.parameterConverter, this.eventGenerator);
        }
        throw new BadBundleException("Request url " + entry.getRequest().getUrl() + " for method DELETE not supported");
    }

    @Override
    public CommandList createCommands(Bundle bundle, Identity identity, PreferReturnType returnType, PreferHandlingType handlingType) throws BadBundleException {
        Objects.requireNonNull(bundle, "bundle");
        Objects.requireNonNull(identity, "identity");
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(handlingType, "handlingType");
        if (bundle.getType() != null) {
            List commands = IntStream.range(0, bundle.getEntry().size()).mapToObj(index -> this.createCommand(index, identity, returnType, handlingType, bundle, (Bundle.BundleEntryComponent)bundle.getEntry().get(index))).flatMap(Function.identity()).collect(Collectors.toList());
            switch (bundle.getType()) {
                case BATCH: {
                    return new BatchCommandList(this.dataSource, this.exceptionHandler, commands, this.validationHelper, this.snapshotGenerator, this.eventHandler);
                }
                case TRANSACTION: {
                    return new TransactionCommandList(this.dataSource, this.exceptionHandler, commands, this.transactionResourcesFactory);
                }
            }
            throw new BadBundleException("Unsupported bundle type " + bundle.getType());
        }
        throw new BadBundleException("Missing bundle type");
    }

    protected Stream<Command> createCommand(int index, Identity identity, PreferReturnType returnType, PreferHandlingType handlingType, Bundle bundle, Bundle.BundleEntryComponent entry) {
        if (entry.hasRequest() && entry.getRequest().hasMethod()) {
            if (!entry.hasResource()) {
                switch (entry.getRequest().getMethod()) {
                    case GET: {
                        return Stream.of(this.get(index, identity, returnType, bundle, entry, handlingType));
                    }
                    case HEAD: {
                        return Stream.of(this.head(index, identity, returnType, bundle, entry, handlingType));
                    }
                    case DELETE: {
                        return Stream.of(this.delete(index, identity, returnType, bundle, entry));
                    }
                }
                throw new BadBundleException("Request method " + entry.getRequest().getMethod() + " at index " + index + " not supported without resource");
            }
            switch (entry.getRequest().getMethod()) {
                case POST: {
                    Command post = this.post(index, identity, returnType, bundle, entry, entry.getResource());
                    return this.resolveReferences(post, index, identity, returnType, bundle, entry, entry.getResource(), Bundle.HTTPVerb.POST);
                }
                case PUT: {
                    Command put = this.put(index, identity, returnType, bundle, entry, entry.getResource());
                    return this.resolveReferences(put, index, identity, returnType, bundle, entry, entry.getResource(), Bundle.HTTPVerb.PUT);
                }
            }
            throw new BadBundleException("Request method " + entry.getRequest().getMethod() + " at index " + index + " not supported with resource");
        }
        throw new BadBundleException("BundleEntry at index " + index + " has no request or request has no method");
    }

    private <R extends Resource> Stream<Command> resolveReferences(Command cmd, int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, R resource, Bundle.HTTPVerb verb) {
        Optional<ResourceDao<?>> dao = this.daoProvider.getDao(resource.getClass());
        if (this.referenceExtractor.getReferences(resource).anyMatch(r -> true)) {
            return dao.map(d -> Stream.of(cmd, new CheckReferencesCommand<Resource, ResourceDao>(index, identity, returnType, bundle, entry, this.serverBase, this.authorizationHelper, resource, verb, (ResourceDao)d, this.exceptionHandler, this.parameterConverter, this.responseGenerator, this.referenceExtractor, this.referenceResolver))).orElseThrow(() -> new IllegalStateException("Resource of type " + resource.getClass().getName() + " not supported"));
        }
        return Stream.of(cmd);
    }
}

