/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.help.ResponseGenerator;
import jakarta.ws.rs.WebApplicationException;
import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHelperImpl
implements AuthorizationHelper {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHelperImpl.class);
    private static final Logger audit = LoggerFactory.getLogger((String)"dsf-audit-logger");
    private final AuthorizationRuleProvider authorizationRuleProvider;
    private final ResponseGenerator responseGenerator;

    public AuthorizationHelperImpl(AuthorizationRuleProvider authorizationRuleProvider, ResponseGenerator responseGenerator) {
        this.authorizationRuleProvider = authorizationRuleProvider;
        this.responseGenerator = responseGenerator;
    }

    private Optional<AuthorizationRule<Resource>> getAuthorizationRule(Class<?> resourceClass) {
        return this.authorizationRuleProvider.getAuthorizationRule(resourceClass).map(rule -> rule);
    }

    private Optional<AuthorizationRule<Resource>> getAuthorizationRule(String resourceTypeName) {
        return this.authorizationRuleProvider.getAuthorizationRule(resourceTypeName).map(rule -> rule);
    }

    private WebApplicationException forbidden(String operation, Identity identity) throws WebApplicationException {
        return new WebApplicationException(this.responseGenerator.forbiddenNotAllowed(operation, identity));
    }

    @Override
    public void checkCreateAllowed(int index, Connection connection, Identity identity, Resource newResource) {
        String resourceTypeName = this.getResourceTypeName(newResource);
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(newResource.getClass());
        optRule.flatMap(rule -> rule.reasonCreateAllowed(connection, identity, newResource)).ifPresentOrElse(reason -> audit.info("Create of {} allowed for identity '{}' via bundle at index {}, reason: {}", new Object[]{resourceTypeName, identity.getName(), index, reason}), () -> {
            audit.info("Create of {} denied for identity '{}' via bundle at index {}", new Object[]{resourceTypeName, identity.getName(), index});
            throw this.forbidden("create", identity);
        });
    }

    private String getResourceTypeName(Resource resource) {
        return resource.getResourceType().name();
    }

    @Override
    public void checkReadAllowed(int index, Connection connection, Identity identity, Resource existingResource) {
        String resourceTypeName = this.getResourceTypeName(existingResource);
        String resourceId = existingResource.getIdElement().getIdPart();
        long resourceVersion = existingResource.getIdElement().getVersionIdPartAsLong();
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(existingResource.getClass());
        optRule.flatMap(rule -> rule.reasonReadAllowed(connection, identity, existingResource)).ifPresentOrElse(reason -> audit.info("Read of {}/{}/_history/{} allowed for identity '{}' via bundle at index {}, reason: {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index, reason}), () -> {
            audit.info("Read of {}/{}/_history/{} denied for identity '{}' via bundle at index {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index});
            throw this.forbidden("read", identity);
        });
    }

    @Override
    public void checkUpdateAllowed(int index, Connection connection, Identity identity, Resource oldResource, Resource newResource) {
        String resourceTypeName = this.getResourceTypeName(oldResource);
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(oldResource.getClass());
        optRule.flatMap(rule -> rule.reasonUpdateAllowed(connection, identity, oldResource, newResource)).ifPresentOrElse(reason -> audit.info("Update of {}/{}/_history/{} allowed for identity '{}' via bundle at index {}, reason: {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index, reason}), () -> {
            audit.info("Update of {}/{}/_history/{} denied for identity '{}' via bundle at index {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index});
            throw this.forbidden("update", identity);
        });
    }

    @Override
    public void checkDeleteAllowed(int index, Connection connection, Identity identity, Resource oldResource) {
        String resourceTypeName = this.getResourceTypeName(oldResource);
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(oldResource.getClass());
        optRule.flatMap(rule -> rule.reasonDeleteAllowed(identity, oldResource)).ifPresentOrElse(reason -> audit.info("Delete of {}/{}/_history/{} allowed for identity '{}' via bundle at index {}, reason: {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index, reason}), () -> {
            audit.info("Delete of {}/{}/_history/{} denied for identity '{}' via bundle at index {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index});
            throw this.forbidden("delete", identity);
        });
    }

    @Override
    public void checkSearchAllowed(int index, Identity identity, String resourceTypeName) {
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(resourceTypeName);
        optRule.flatMap(rule -> rule.reasonSearchAllowed(identity)).ifPresentOrElse(reason -> audit.info("Search of {} allowed for identity '{}' via bundle at index {}, reason: {}", new Object[]{resourceTypeName, identity.getName(), index, reason}), () -> {
            audit.info("Search of {} denied for identity '{}' via bundle at index {}", new Object[]{resourceTypeName, identity.getName(), index});
            throw this.forbidden("search", identity);
        });
    }

    @Override
    public void filterIncludeResults(int index, Connection connection, Identity identity, Bundle multipleResult) {
        List filteredEntries = multipleResult.getEntry().stream().filter(c -> Bundle.SearchEntryMode.MATCH.equals((Object)c.getSearch().getMode()) || Bundle.SearchEntryMode.INCLUDE.equals((Object)c.getSearch().getMode()) && this.filterIncludeResource(index, identity, c.getResource())).collect(Collectors.toList());
        multipleResult.setEntry(filteredEntries);
    }

    private boolean filterIncludeResource(int index, Identity identity, Resource include) {
        String resourceTypeName = this.getResourceTypeName(include);
        String resourceId = include.getIdElement().getIdPart();
        long resourceVersion = include.getIdElement().getVersionIdPartAsLong();
        Optional<AuthorizationRule<Resource>> optRule = this.getAuthorizationRule(include.getClass());
        return optRule.flatMap(rule -> rule.reasonReadAllowed(identity, include)).map(reason -> {
            logger.debug("Inclusion of {}/{}/_history/{} allowed for identity '{}' via bundle at index {}: {}", new Object[]{resourceTypeName, resourceId, resourceVersion, identity.getName(), index, reason});
            return true;
        }).orElseGet(() -> {
            logger.debug("Inclusion of {}/{}/_history/{} denied for identity '{} via bundle at index {}: read not allowed", new Object[]{resourceTypeName, resourceId, resourceVersion, index, identity.getName(), index});
            return false;
        });
    }
}

