/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import dev.dsf.fhir.authentication.AbstractIdentity;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;

public class PractitionerIdentityImpl
extends AbstractIdentity
implements PractitionerIdentity {
    private final Practitioner practitioner;
    private final DsfOpenIdCredentials credentials;
    private final Set<Coding> practitionerRoles = new HashSet<Coding>();

    public PractitionerIdentityImpl(Organization organization, Collection<? extends DsfRole> dsfRoles, X509Certificate certificate, Practitioner practitioner, Collection<? extends Coding> practitionerRoles, DsfOpenIdCredentials credentials) {
        super(true, organization, dsfRoles, certificate);
        this.practitioner = Objects.requireNonNull(practitioner, "practitioner");
        if (practitionerRoles != null) {
            this.practitionerRoles.addAll(practitionerRoles);
        }
        this.credentials = credentials;
    }

    public String getName() {
        return this.getOrganizationIdentifierValue().orElse("?") + "/" + this.getIdentifierValue(() -> ((Practitioner)this.practitioner).getIdentifier(), "http://dsf.dev/sid/practitioner-identifier").orElse("?");
    }

    public String getDisplayName() {
        return this.practitioner.hasName() ? this.practitioner.getNameFirstRep().getNameAsSingleString() : "";
    }

    public Practitioner getPractitioner() {
        return this.practitioner;
    }

    public Set<Coding> getPractionerRoles() {
        return Collections.unmodifiableSet(this.practitionerRoles);
    }

    public Optional<DsfOpenIdCredentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }
}

