/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Hex;

public abstract class AbstractProvider {
    protected String getThumbprint(X509Certificate certificate) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-512").digest(certificate.getEncoded());
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDn(X509Certificate certificate) {
        return certificate.getSubjectX500Principal().getName("RFC1779");
    }
}

