/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.HtmlGenerator;
import dev.dsf.fhir.adapter.ResourceHtmlGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

public class EndpointHtmlGenerator
extends ResourceHtmlGenerator
implements HtmlGenerator<Endpoint> {
    @Override
    public Class<Endpoint> getResourceType() {
        return Endpoint.class;
    }

    @Override
    public void writeHtml(URI resourceUri, Endpoint resource, OutputStreamWriter out) throws IOException {
        List<String> payloadMimeTypes;
        List<String> payloadTypes;
        List<String> identifiers;
        out.write("<div class=\"resource\">\n");
        out.write("<div class=\"row\" status=\"" + (resource.hasStatus() ? resource.getStatus().toCode() : "") + "\">\n");
        out.write("</div>\n");
        this.writeMeta((Resource)resource, out);
        this.writeRow("Status", resource.hasStatus() ? resource.getStatus().toCode() : "", out);
        this.writeSectionHeader("Endpoint", out);
        if (resource.hasName()) {
            this.writeRow("Name", resource.getName(), out);
        }
        if (resource.hasAddress()) {
            this.writeRow("Address", resource.getAddress(), out);
        }
        if (!(identifiers = resource.getIdentifier().stream().map(i -> (i.hasSystem() ? i.getSystem() : "") + " | <b>" + (i.hasValue() ? i.getValue() : "") + "</b>").toList()).isEmpty()) {
            this.writeRowWithList("Identifiers", identifiers, out);
        }
        if (resource.hasManagingOrganization() && resource.getManagingOrganization().hasReference()) {
            this.writeRowWithLink("Managing Organization", ResourceType.Organization.name(), resource.getManagingOrganization().getReferenceElement().getIdPart(), out);
        }
        if (resource.hasConnectionType()) {
            String connectionType = (resource.getConnectionType().hasSystem() ? resource.getConnectionType().getSystem() : "") + " | <b>" + (resource.getConnectionType().hasCode() ? resource.getConnectionType().getCode() : "") + "</b>";
            this.writeRow("Connection Type", connectionType, out);
        }
        if (!(payloadTypes = resource.getPayloadType().stream().flatMap(c -> c.getCoding().stream()).map(c -> (c.hasSystem() ? c.getSystem() : "") + " | <b>" + (c.hasCode() ? c.getCode() : "") + "</b>").toList()).isEmpty()) {
            this.writeRowWithList("Payload Types", payloadTypes, out);
        }
        if (!(payloadMimeTypes = resource.getPayloadMimeType().stream().map(c -> c.getCode()).toList()).isEmpty()) {
            this.writeRowWithList("Payload Mime Types", payloadMimeTypes, out);
        }
        out.write("</div>\n");
    }

    @Override
    public boolean isResourceSupported(URI resourceUri, Resource resource) {
        return resource != null && resource instanceof Endpoint;
    }
}

