/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractVersionParameter<R extends MetadataResource>
extends AbstractTokenParameter<R> {
    public static final String PARAMETER_NAME = "version";
    private final String resourceColumn;
    private String version;

    public AbstractVersionParameter(String resourceColumn) {
        super(PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.version = this.valueAndType.codeValue;
        } else if (this.valueAndType != null) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_NAME, queryParameterValue));
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.version != null;
    }

    @Override
    public String getFilterQuery() {
        return this.resourceColumn + "->>'version' " + (this.valueAndType.negated ? "<>" : "=") + " ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.version);
    }

    protected abstract boolean instanceOf(Resource var1);

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!this.instanceOf(resource)) {
            return false;
        }
        MetadataResource mRes = (MetadataResource)resource;
        if (this.valueAndType.negated) {
            return !Objects.equals(mRes.getVersion(), this.version);
        }
        return Objects.equals(mRes.getVersion(), this.version);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->>'version'" + sortDirectionWithSpacePrefix;
    }
}

