/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Task-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="Search for a task instance by its business identifier")
public class TaskIdentifier
extends AbstractIdentifierParameter<Task> {
    public static final String RESOURCE_COLUMN = "task";

    public TaskIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Task)) {
            return false;
        }
        Task t = (Task)resource;
        return this.identifierMatches(t.getIdentifier());
    }
}

