/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="_profile", definition="http://hl7.org/fhir/SearchParameter/Resource-profile", type=Enumerations.SearchParamType.TOKEN, documentation="Profiles this resource claims to conform to")
public class ResourceProfile<R extends Resource>
extends AbstractCanonicalUrlParameter<R> {
    public static final String PARAMETER_NAME = "_profile";
    private final String resourceColumn;

    public ResourceProfile(String resourceColumn) {
        super(PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case PRECISE: {
                if (this.valueAndType.version != null) {
                    return this.resourceColumn + "->'meta'->'profile' ?? ?";
                }
                return "(" + this.resourceColumn + "->'meta'->'profile' ?? ? OR EXISTS (SELECT 1 FROM (SELECT jsonb_array_elements_text(" + this.resourceColumn + "->'meta'->'profile') AS profile) AS profiles WHERE profile LIKE ?))";
            }
            case BELOW: {
                return "EXISTS (SELECT 1 FROM (SELECT jsonb_array_elements_text(" + this.resourceColumn + "->'meta'->'profile') AS profile) AS profiles WHERE profile LIKE ?)";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        switch (this.valueAndType.type) {
            case PRECISE: {
                return this.valueAndType.version != null ? 1 : 2;
            }
            case BELOW: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        switch (this.valueAndType.type) {
            case PRECISE: {
                if (this.valueAndType.version != null) {
                    statement.setString(parameterIndex, this.valueAndType.url + "|" + this.valueAndType.version);
                } else {
                    if (subqueryParameterIndex == 1) {
                        statement.setString(parameterIndex, this.valueAndType.url);
                    }
                    if (subqueryParameterIndex == 2) {
                        statement.setString(parameterIndex, this.valueAndType.url + "|%");
                    }
                }
                return;
            }
            case BELOW: {
                if (this.valueAndType.version != null) {
                    statement.setString(parameterIndex, this.valueAndType.url + "%|" + this.valueAndType.version);
                } else {
                    statement.setString(parameterIndex, this.valueAndType.url + "%");
                }
                return;
            }
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        switch (this.valueAndType.type) {
            case PRECISE: {
                if (this.valueAndType.version != null) {
                    return resource.getMeta().getProfile().stream().anyMatch(p -> ((String)p.getValue()).equals(this.valueAndType.url + "|" + this.valueAndType.version));
                }
                return resource.getMeta().getProfile().stream().anyMatch(p -> ((String)p.getValue()).equals(this.valueAndType.url));
            }
            case BELOW: {
                if (this.valueAndType.version != null) {
                    return resource.getMeta().getProfile().stream().anyMatch(p -> ((String)p.getValue()).startsWith(this.valueAndType.url) && ((String)p.getValue()).endsWith("|" + this.valueAndType.version));
                }
                return resource.getMeta().getProfile().stream().anyMatch(p -> ((String)p.getValue()).startsWith(this.valueAndType.url));
            }
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->'meta'->>'profile'" + sortDirectionWithSpacePrefix;
    }
}

