/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="name", definition="http://hl7.org/fhir/SearchParameter/Organization-name", type=Enumerations.SearchParamType.STRING, documentation="A portion of the organization's name or alias")
public class OrganizationName
extends AbstractStringParameter<Organization> {
    public static final String PARAMETER_NAME = "name";

    public OrganizationName() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case STARTS_WITH: 
            case CONTAINS: {
                return "(lower(organization->>'name') LIKE ? OR lower(organization->>'alias') LIKE ?)";
            }
            case EXACT: {
                return "(organization->>'name' = ? OR organization->>'alias' = ?)";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 2;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                statement.setString(parameterIndex, this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case CONTAINS: {
                statement.setString(parameterIndex, "%" + this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case EXACT: {
                statement.setString(parameterIndex, this.valueAndType.value);
                return;
            }
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)resource;
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                return o.getName() != null && o.getName().toLowerCase().startsWith(this.valueAndType.value.toLowerCase());
            }
            case CONTAINS: {
                return o.getName() != null && o.getName().toLowerCase().contains(this.valueAndType.value.toLowerCase());
            }
            case EXACT: {
                return Objects.equals(o.getName(), this.valueAndType.value);
            }
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "organization->>'name'" + sortDirectionWithSpacePrefix + ", organization->>'alias'" + sortDirectionWithSpacePrefix;
    }
}

