/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractCanonicalUrlParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="address", definition="http://hl7.org/fhir/SearchParameter/Endpoint-address", type=Enumerations.SearchParamType.URI, documentation="The address (url) of the endpoint")
public class EndpointAddress
extends AbstractCanonicalUrlParameter<Endpoint> {
    public static final String PARAMETER_NAME = "address";

    public EndpointAddress() {
        super(PARAMETER_NAME);
    }

    @Override
    public String getFilterQuery() {
        switch (this.valueAndType.type) {
            case PRECISE: {
                return "endpoint->>'address' = ?";
            }
            case BELOW: {
                return "endpoint->>'address' LIKE ?";
            }
        }
        return "";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case PRECISE: {
                statement.setString(parameterIndex, this.valueAndType.url);
                return;
            }
            case BELOW: {
                statement.setString(parameterIndex, this.valueAndType.url + "%");
                return;
            }
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)resource;
        switch (this.valueAndType.type) {
            case PRECISE: {
                return Objects.equals(endpoint.getAddress(), this.valueAndType.url);
            }
            case BELOW: {
                return endpoint.getAddress() != null && endpoint.getAddress().startsWith(this.valueAndType.url);
            }
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "endpoint->>'address'" + sortDirectionWithSpacePrefix;
    }
}

