/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/ActivityDefinition-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="External identifier for the activity definition")
public class ActivityDefinitionIdentifier
extends AbstractIdentifierParameter<ActivityDefinition> {
    public static final String RESOURCE_COLUMN = "activity_definition";

    public ActivityDefinitionIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition e = (ActivityDefinition)resource;
        return this.identifierMatches(e.getIdentifier());
    }
}

