/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.help;

import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.help.SummaryMode;
import dev.dsf.fhir.history.History;
import dev.dsf.fhir.history.HistoryEntry;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ResourceReference;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ResponseGenerator.class);
    public static final CacheControl PRIVATE_NO_CACHE_NO_TRANSFORM = new CacheControl();
    private final String serverBase;

    public ResponseGenerator(String serverBase) {
        this.serverBase = serverBase;
    }

    public OperationOutcome createOutcome(OperationOutcome.IssueSeverity severity, OperationOutcome.IssueType type, String diagnostics) {
        OperationOutcome outcome = new OperationOutcome();
        outcome.getIssueFirstRep().setSeverity(severity);
        outcome.getIssueFirstRep().setCode(type);
        outcome.getIssueFirstRep().setDiagnostics(diagnostics);
        return outcome;
    }

    public OperationOutcome resourceDeleted(String resourceTypeName, String id) {
        return this.createOutcome(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INFORMATIONAL, resourceTypeName + " with id " + id + " marked as deleted");
    }

    public OperationOutcome resourceDeletedPermanently(String resourceTypeName, String id) {
        return this.createOutcome(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INFORMATIONAL, resourceTypeName + " with id " + id + " permanently deleted");
    }

    public Response.ResponseBuilder response(Response.Status status, Resource resource, MediaType mediaType) {
        return this.response(status, resource, mediaType, PreferReturnType.REPRESENTATION, null);
    }

    public Response.ResponseBuilder response(Response.Status status, Resource resource, MediaType mediaType, PreferReturnType prefer, Supplier<OperationOutcome> operationOutcomeCreator) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(resource, "resource");
        Response.ResponseBuilder b = Response.status((Response.Status)status);
        switch (prefer) {
            case REPRESENTATION: {
                b = b.entity((Object)resource);
                break;
            }
            case OPERATION_OUTCOME: {
                b = b.entity((Object)operationOutcomeCreator.get());
                break;
            }
            case MINIMAL: {
                break;
            }
            default: {
                throw new RuntimeException(PreferReturnType.class.getName() + " value " + prefer + " not supported");
            }
        }
        if (mediaType != null) {
            b = b.type(mediaType.withCharset(StandardCharsets.UTF_8.displayName()));
        }
        if (resource.getMeta() != null && resource.getMeta().getLastUpdated() != null && resource.getMeta().getVersionId() != null) {
            b = b.lastModified(resource.getMeta().getLastUpdated());
            b = b.tag(new EntityTag(resource.getMeta().getVersionId(), true));
        }
        b = b.cacheControl(PRIVATE_NO_CACHE_NO_TRANSFORM);
        return b;
    }

    public OperationOutcome created(URI location, Resource resource) {
        return this.created(location.toString(), resource);
    }

    public OperationOutcome created(String location, Resource resource) {
        String message = String.format("%s created at location %s", resource.getResourceType().name(), location);
        return this.createOutcome(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INFORMATIONAL, message);
    }

    public OperationOutcome updated(URI location, Resource resource) {
        return this.updated(location.toString(), resource);
    }

    public OperationOutcome updated(String location, Resource resource) {
        String message = String.format("%s updated at location %s", resource.getResourceType().name(), location);
        return this.createOutcome(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INFORMATIONAL, message);
    }

    public Bundle createSearchSet(PartialResult<? extends Resource> result, List<SearchQueryParameterError> errors, UriBuilder bundleUri, String format, String pretty, SummaryMode summaryMode) {
        Bundle bundle = new Bundle();
        bundle.setTimestamp(new Date());
        bundle.setType(Bundle.BundleType.SEARCHSET);
        if (!SummaryMode.COUNT.equals((Object)summaryMode)) {
            result.getPartialResult().stream().map(r -> this.toBundleEntryComponent((Resource)r, Bundle.SearchEntryMode.MATCH)).forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
            result.getIncludes().stream().map(r -> this.toBundleEntryComponent((Resource)r, Bundle.SearchEntryMode.INCLUDE)).forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        }
        if (!errors.isEmpty()) {
            bundle.addEntry(this.toBundleEntryComponent((Resource)this.toOperationOutcomeWarning(errors), Bundle.SearchEntryMode.OUTCOME));
        }
        bundle.setTotal(result.getTotal());
        this.setLinks(result.getPageAndCount(), bundleUri, format, pretty, summaryMode, bundle, result.getPartialResult().isEmpty(), result.getTotal());
        return bundle;
    }

    public Bundle.BundleEntryComponent toBundleEntryComponent(Resource resource, Bundle.SearchEntryMode mode) {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.getSearch().setMode(mode);
        entry.setResource(resource);
        entry.setFullUrlElement((UriType)new IdType(this.serverBase, resource.getIdElement().getResourceType(), resource.getIdElement().getIdPart(), null));
        return entry;
    }

    public Bundle createHistoryBundle(History history, List<SearchQueryParameterError> errors, UriBuilder bundleUri, String format, String pretty, SummaryMode summaryMode) {
        Bundle bundle = new Bundle();
        bundle.setTimestamp(new Date());
        bundle.setType(Bundle.BundleType.HISTORY);
        if (!SummaryMode.COUNT.equals((Object)summaryMode)) {
            history.getEntries().stream().map(e -> this.toBundleEntryComponent((HistoryEntry)e)).forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        }
        if (!errors.isEmpty()) {
            bundle.addEntry(this.toBundleEntryComponent((Resource)this.toOperationOutcomeWarning(errors), Bundle.SearchEntryMode.OUTCOME));
        }
        bundle.setTotal(history.getTotal());
        this.setLinks(history.getPageAndCount(), bundleUri, format, pretty, summaryMode, bundle, history.getEntries().isEmpty(), history.getTotal());
        return bundle;
    }

    public Bundle.BundleEntryComponent toBundleEntryComponent(HistoryEntry historyEntry) {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.setFullUrlElement((UriType)new IdType(this.serverBase, historyEntry.getResourceType(), historyEntry.getId().toString(), null));
        entry.getRequest().setMethod(Bundle.HTTPVerb.fromCode((String)historyEntry.getMethod())).setUrl(historyEntry.getResourceType() + (String)(historyEntry.getResource() == null ? "/" + historyEntry.getId().toString() + "/_history/" + historyEntry.getVersion() : ""));
        entry.setResource(historyEntry.getResource());
        Bundle.BundleEntryResponseComponent response = entry.getResponse();
        response.setStatus(this.toStatus(historyEntry.getMethod()));
        response.setLocation(this.toLocation(historyEntry.getResourceType(), historyEntry.getId().toString(), historyEntry.getVersion()));
        response.setEtag(RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)new EntityTag(historyEntry.getVersion(), true)));
        response.setLastModified(Date.from(historyEntry.getLastUpdated().atZone(ZoneId.systemDefault()).toInstant()));
        return entry;
    }

    private String toStatus(String method) {
        switch (method) {
            case "POST": {
                return "201 Created";
            }
            case "PUT": {
                return "200 OK";
            }
            case "DELETE": {
                return "200 OK";
            }
        }
        throw new RuntimeException("Method " + method + " not supported");
    }

    private String toLocation(String resourceType, String id, String version) {
        return new IdType(this.serverBase, resourceType, id, version).getValue();
    }

    private void setLinks(PageAndCount pageAndCount, UriBuilder bundleUri, String format, String pretty, SummaryMode summaryMode, Bundle bundle, boolean isEmpty, int total) {
        if (format != null) {
            bundleUri = bundleUri.replaceQueryParam("_format", new Object[]{format});
        }
        if (pretty != null) {
            bundleUri = bundleUri.replaceQueryParam("_pretty", new Object[]{pretty});
        }
        if (summaryMode != null) {
            bundleUri = bundleUri.replaceQueryParam("_summary", new Object[]{summaryMode.toString()});
        }
        if (pageAndCount.getCount() > 0) {
            bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{pageAndCount.getCount()});
            bundleUri = bundleUri.replaceQueryParam("_page", new Object[]{isEmpty ? 1 : pageAndCount.getPage()});
        } else {
            bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{"0"});
        }
        bundle.addLink().setRelation("self").setUrlElement(new UriType(bundleUri.build(new Object[0])));
        if (pageAndCount.getCount() > 0 && !isEmpty) {
            bundleUri = bundleUri.replaceQueryParam("_page", new Object[]{1});
            bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{pageAndCount.getCount()});
            bundle.addLink().setRelation("first").setUrlElement(new UriType(bundleUri.build(new Object[0])));
            if (pageAndCount.getPage() > 1) {
                bundleUri = bundleUri.replaceQueryParam("_page", new Object[]{pageAndCount.getPage() - 1});
                bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{pageAndCount.getCount()});
                bundle.addLink().setRelation("previous").setUrlElement(new UriType(bundleUri.build(new Object[0])));
            }
            if (!pageAndCount.isLastPage(total)) {
                bundleUri = bundleUri.replaceQueryParam("_page", new Object[]{pageAndCount.getPage() + 1});
                bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{pageAndCount.getCount()});
                bundle.addLink().setRelation("next").setUrlElement(new UriType(bundleUri.build(new Object[0])));
            }
            bundleUri = bundleUri.replaceQueryParam("_page", new Object[]{pageAndCount.getLastPage(total)});
            bundleUri = bundleUri.replaceQueryParam("_count", new Object[]{pageAndCount.getCount()});
            bundle.addLink().setRelation("last").setUrlElement(new UriType(bundleUri.build(new Object[0])));
        }
    }

    public OperationOutcome toOperationOutcomeWarning(List<SearchQueryParameterError> errors) {
        return this.toOperationOutcome(errors, OperationOutcome.IssueSeverity.WARNING);
    }

    public OperationOutcome toOperationOutcomeError(List<SearchQueryParameterError> errors) {
        return this.toOperationOutcome(errors, OperationOutcome.IssueSeverity.ERROR);
    }

    private OperationOutcome toOperationOutcome(List<SearchQueryParameterError> errors, OperationOutcome.IssueSeverity severity) {
        String diagnostics = errors.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        return this.createOutcome(severity, OperationOutcome.IssueType.PROCESSING, diagnostics);
    }

    public Response pathVsElementId(String resourceTypeName, String id, IdType resourceId) {
        logger.warn("Path id not equal to {} id ({} vs. {})", new Object[]{resourceTypeName, id, resourceId.getIdPart()});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Path id not equal to " + resourceTypeName + " id (" + id + " vs. " + resourceId.getIdPart() + ")");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response invalidBaseUrl(String resourceTypeName, IdType resourceId) {
        logger.warn("{} id.baseUrl must be null or equal to {}, value {} unexpected", new Object[]{resourceTypeName, this.serverBase, resourceId.getBaseUrl()});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " id.baseUrl must be null or equal to " + this.serverBase + ", value " + resourceId.getBaseUrl() + " unexpected");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response badRequest(String queryParameters, List<SearchQueryParameterError> unsupportedQueryParameters) {
        String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        logger.warn("Bad request '{}', unsupported query parameter{} {}", new Object[]{queryParameters, unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString});
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad request '" + queryParameters + "', unsupported query parameter" + (unsupportedQueryParameters.size() != 1 ? "s" : "") + " " + unsupportedQueryParametersString);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badRequestIdsNotMatching(IdType dbResourceId, IdType resourceId) {
        logger.warn("Bad request Id {} does not match db Id {}", (Object)resourceId.getValue(), (Object)dbResourceId.getValue());
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad request Id " + resourceId.getValue() + " does not match db Id " + dbResourceId.getValue());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response updateAsCreateNotAllowed(String resourceTypeName) {
        logger.warn("Update as create of resource with type {} not allowed", (Object)resourceTypeName);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.FORBIDDEN, "Update as create not allowed");
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)outcome).build();
    }

    public Response multipleExists(String resourceTypeName, String ifNoneExistsHeaderValue) {
        logger.warn("Multiple {} resources with criteria {} exist", (Object)resourceTypeName, (Object)ifNoneExistsHeaderValue);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.MULTIPLEMATCHES, "Multiple " + resourceTypeName + " resources with criteria '" + ifNoneExistsHeaderValue + "' exist");
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)outcome).build();
    }

    public Response badIfNoneExistHeaderValue(String ifNoneExistsHeaderValue) {
        logger.warn("Bad If-None-Exist header value '{}'", (Object)ifNoneExistsHeaderValue);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad If-None-Exist header value '" + ifNoneExistsHeaderValue + "'");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badIfNoneExistHeaderValue(String ifNoneExistsHeaderValue, List<SearchQueryParameterError> unsupportedQueryParameters) {
        String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        logger.warn("Bad If-None-Exist header value '{}', unsupported query parameter{} {}", new Object[]{ifNoneExistsHeaderValue, unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString});
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad If-None-Exist header value '" + ifNoneExistsHeaderValue + "', unsupported query parameter" + (unsupportedQueryParameters.size() != 1 ? "s" : "") + " " + unsupportedQueryParametersString);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response oneExists(Resource resource, String ifNoneExistsHeaderValue) {
        logger.info("{} with criteria {} exists", (Object)resource.getResourceType().name(), (Object)ifNoneExistsHeaderValue);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.DUPLICATE, "Resource with criteria '" + ifNoneExistsHeaderValue + "' exists");
        UriBuilder uri = UriBuilder.fromPath((String)this.serverBase);
        URI location = uri.path("/{resourceType}/{id}/_history/{vid}").build(new Object[]{resource.getResourceType().name(), resource.getIdElement().getIdPart(), resource.getIdElement().getVersionIdPart()});
        return Response.status((Response.Status)Response.Status.OK).entity((Object)outcome).location(location).lastModified(resource.getMeta().getLastUpdated()).tag(new EntityTag(resource.getMeta().getVersionId(), true)).cacheControl(PRIVATE_NO_CACHE_NO_TRANSFORM).header("Vary", (Object)"Cookie").build();
    }

    public OperationOutcome unknownReference(Resource resource, ResourceReference resourceReference) {
        return this.unknownReference(resource, resourceReference, null);
    }

    public OperationOutcome unknownReference(Resource resource, ResourceReference resourceReference, Integer bundleIndex) {
        if (bundleIndex == null) {
            logger.warn("Unknown reference at {} in resource of type {} with id {}", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Unknown reference at {} in resource of type {} with id {} at bundle index {}", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Unknown reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex));
    }

    public OperationOutcome referenceTargetTypeNotSupportedByImplementation(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Reference target type of reference at {} in resource of type {} with id {} not supported by this implementation", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Reference target type of reference at {} in resource of type {} with id {} at bundle index {} not supported by this implementation", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target type of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not supported by this implementation");
    }

    public OperationOutcome referenceTargetTypeNotSupportedByResource(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Reference target type of reference at {} in resource of type {} with id {} not supported", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Reference target type of reference at {} in resource of type {} with id {} at bundle index {} not supported", new Object[]{resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target type of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not supported");
    }

    public OperationOutcome referenceTargetNotFoundLocally(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} not found", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} at bundle index {} not found", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target " + resourceReference.getValue() + " of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome referenceTargetNotFoundRemote(Integer bundleIndex, Resource resource, ResourceReference resourceReference, String serverBase) {
        if (bundleIndex == null) {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} not found on server {}", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), serverBase});
        } else {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} at bundle index {} not found on server {}", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex, serverBase});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target " + resourceReference.getValue() + " of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found on server " + serverBase);
    }

    public OperationOutcome referenceTargetCouldNotBeResolvedOnRemote(Integer bundleIndex, Resource resource, ResourceReference resourceReference, String serverBase) {
        if (bundleIndex == null) {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} could not be resolved on server {} (reason hidden)", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), serverBase});
        } else {
            logger.warn("Reference target {} of reference at {} in resource of type {} with id {} at bundle index {} could not be resolved on server {} (reason hidden)", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex, serverBase});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target " + resourceReference.getValue() + " of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " could not be resolved on server " + serverBase + " (reason hidden)");
    }

    public OperationOutcome noEndpointFoundForLiteralExternalReference(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("No Endpoint found for reference target {} of reference at {} in resource of type {} with id {}", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("No Endpoint found for reference target {} of reference at {} in resource of type {} with id {} at bundle index {} not found", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "No Endpoint found for reference target " + resourceReference.getValue() + " of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome badReference(boolean logicalNotConditional, Integer bundleIndex, Resource resource, ResourceReference resourceReference, String queryParameters, List<SearchQueryParameterError> unsupportedQueryParameters) {
        String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        if (bundleIndex == null) {
            logger.warn("{} reference {} at {} in resource of type {} with id {} contains unsupported queryparameter{} {}", new Object[]{logicalNotConditional ? "Logical" : "Conditional", queryParameters, resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString});
        } else {
            logger.warn("{} reference {} at {} in resource of type {} with id {} at bundle index {} contains unsupported queryparameter{} {}", new Object[]{logicalNotConditional ? "Logical" : "Conditional", queryParameters, resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex, unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, (logicalNotConditional ? "Logical" : "Conditional") + " reference " + queryParameters + " at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " contains unsupported queryparameter" + (unsupportedQueryParameters.size() != 1 ? "s" : "") + " " + unsupportedQueryParametersString);
    }

    public OperationOutcome referenceTargetNotFoundLocallyByIdentifier(Resource resource, ResourceReference resourceReference) {
        return this.referenceTargetNotFoundLocallyByIdentifier(null, resource, resourceReference);
    }

    public OperationOutcome referenceTargetNotFoundLocallyByIdentifier(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Reference target by identifier '{}|{}' of reference at {} in resource of type {} with id {} not found", new Object[]{resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Reference target by identifier '{}|{}' of reference at {} in resource of type {} with id {} at bundle index {} not found", new Object[]{resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target by identifier '" + resourceReference.getReference().getIdentifier().getSystem() + "|" + resourceReference.getReference().getIdentifier().getValue() + "' of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome referenceTargetMultipleMatchesLocallyByIdentifier(Integer bundleIndex, Resource resource, ResourceReference resourceReference, int overallCount) {
        if (bundleIndex == null) {
            logger.warn("Found {} matches for reference target by identifier '{}|{}' of reference at {} in resource of type {} with id {}", new Object[]{overallCount, resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Found {} matches for reference target by identifier '{}|{}' of reference at {} in resource of type {} with id {} at bundle index {}", new Object[]{overallCount, resourceReference.getReference().getIdentifier().getSystem(), resourceReference.getReference().getIdentifier().getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Found " + overallCount + " matches for reference target by identifier '" + resourceReference.getReference().getIdentifier().getSystem() + "|" + resourceReference.getReference().getIdentifier().getValue() + "' of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome referenceTargetNotFoundLocallyByCondition(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Reference target by condition '{}' of reference at {} in resource of type {} with id {} not found", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Reference target by condition '{}' of reference at {} in resource of type {} with id {} at bundle index {} not found", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Reference target by condition '" + resourceReference.getValue() + "' of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome referenceTargetMultipleMatchesLocallyByCondition(Integer bundleIndex, Resource resource, ResourceReference resourceReference, int overallCount) {
        if (bundleIndex == null) {
            logger.warn("Found {} matches for reference target by condition '{}' of reference at {} in resource of type {} with id {}", new Object[]{overallCount, resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Found {} matches for reference target by condition '{}' of reference at {} in resource of type {} with id {} at bundle index {}", new Object[]{overallCount, resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Found " + overallCount + " matches for reference target by condition '" + resourceReference.getValue() + "' of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public OperationOutcome referenceTargetBadCondition(Integer bundleIndex, Resource resource, ResourceReference resourceReference) {
        if (bundleIndex == null) {
            logger.warn("Bad conditional reference target '{}' of reference at {} in resource of type {} with id {}", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId()});
        } else {
            logger.warn("Bad conditional reference target '{}' of reference at {} in resource of type {} with id {} at bundle index {}", new Object[]{resourceReference.getValue(), resourceReference.getLocation(), resource.getResourceType().name(), resource.getId(), bundleIndex});
        }
        return this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad conditional reference target '" + resourceReference.getValue() + "' of reference at " + resourceReference.getLocation() + " in resource of type " + resource.getResourceType().name() + " with id " + resource.getId() + (String)(bundleIndex == null ? "" : " at bundle index " + bundleIndex) + " not found");
    }

    public Response badDeleteRequestUrl(int bundleIndex, String url) {
        logger.warn("Bad delete request url {} at bundle index {}", (Object)url, (Object)bundleIndex);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad delete request url " + url + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badCreateRequestUrl(int bundleIndex, String url) {
        logger.warn("Bad crate request url {} at bundle index {}", (Object)url, (Object)bundleIndex);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad crete request url " + url + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badUpdateRequestUrl(int bundleIndex, String url) {
        logger.warn("Bad update request url {} at bundle index {}", (Object)url, (Object)bundleIndex);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad update request url " + url + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badReadRequestUrl(int bundleIndex, String url) {
        logger.warn("Bad read request url {} at bundle index {}", (Object)url, (Object)bundleIndex);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad read request url " + url + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response resourceTypeNotSupportedByImplementation(int bundleIndex, String resourceTypeName) {
        logger.warn("Resource type {} at bundle index {} not supported by this implementation", (Object)resourceTypeName, (Object)bundleIndex);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Resource type " + resourceTypeName + " at bundle index " + bundleIndex + " not supported by this implementation");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badConditionalDeleteRequest(int bundleIndex, String queryParameters, List<SearchQueryParameterError> unsupportedQueryParameters) {
        String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        logger.warn("Bad conditional delete request '{}', unsupported query parameter{} {} at bundle index {}", new Object[]{queryParameters, unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString, bundleIndex});
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad conditional delete request '" + queryParameters + "', unsupported query parameter" + (unsupportedQueryParameters.size() != 1 ? "s" : "") + " " + unsupportedQueryParametersString + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response badConditionalDeleteRequestMultipleMatches(int bundleIndex, String resourceTypeName, String queryParameters) {
        logger.warn("Multiple {} resources with criteria '{}' exist for delete request at bundle index {}", new Object[]{resourceTypeName, queryParameters, bundleIndex});
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.MULTIPLEMATCHES, "Multiple " + resourceTypeName + " resources with criteria '" + queryParameters + "' exist for delete request at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)outcome).build();
    }

    public Response badBundleRequest(String message) {
        logger.warn("Bad bundle request - {}", (Object)message);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad bundle request - " + message);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response pathVsElementIdInBundle(int bundleIndex, String resourceTypeName, String id, IdType resourceId) {
        logger.warn("Path id not equal to {} id ({} vs. {}) at bundle index {}", new Object[]{resourceTypeName, id, resourceId.getIdPart(), bundleIndex});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Path id not equal to " + resourceTypeName + " id (" + id + " vs. " + resourceId.getIdPart() + ") at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response invalidBaseUrlInBundle(int bundleIndex, String resourceTypeName, IdType resourceId) {
        logger.warn("{} id.baseUrl must be null or equal to {}, value {} unexpected at bundle index {}", new Object[]{resourceTypeName, this.serverBase, resourceId.getBaseUrl(), bundleIndex});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " id.baseUrl must be null or equal to " + this.serverBase + ", value " + resourceId.getBaseUrl() + " unexpected at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response nonMatchingResourceTypeAndRequestUrlInBundle(int bundleIndex, String resourceTypeName, String url) {
        logger.warn("Non matching resource type {} and request url {} at bundle index {}", new Object[]{resourceTypeName, url, bundleIndex});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Non matching resource type " + resourceTypeName + " and request url " + url + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response unsupportedConditionalUpdateQuery(int bundleIndex, String query, List<SearchQueryParameterError> unsupportedQueryParameters) {
        String unsupportedQueryParametersString = unsupportedQueryParameters.stream().map(SearchQueryParameterError::toString).collect(Collectors.joining("; "));
        logger.warn("Bad conditional update request '{}', unsupported query parameter{} {} at bundle index {}", new Object[]{query, unsupportedQueryParameters.size() != 1 ? "s" : "", unsupportedQueryParametersString, bundleIndex});
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad conditional update request '" + query + "', unsupported query parameter" + (unsupportedQueryParameters.size() != 1 ? "s" : "") + " " + unsupportedQueryParametersString + " at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    public Response bundleEntryResouceMissingId(int bundleIndex, String resourceTypeName) {
        logger.warn("Bundle entry of type {} at bundle index {} is missing id value", (Object)resourceTypeName, (Object)bundleIndex);
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bundle entry of type " + resourceTypeName + " at bundle index " + bundleIndex + " is missing id value");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response badBundleEntryFullUrl(int bundleIndex, String fullUrl) {
        logger.warn("Bad entry fullUrl '{}' at bundle index {}", (Object)fullUrl, (Object)bundleIndex);
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bad entry fullUrl '" + fullUrl + "' at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response bundleEntryBadResourceId(int bundleIndex, String resourceTypeName, String urlUuidPrefix) {
        logger.warn("Bundle entry of type {} at bundle index {} id value not starting with {}", new Object[]{resourceTypeName, bundleIndex, urlUuidPrefix});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Bundle entry of type " + resourceTypeName + " at bundle index " + bundleIndex + " id value not starting with " + urlUuidPrefix);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response badBundleEntryFullUrlVsResourceId(int bundleIndex, String fullUrl, String idValue) {
        logger.warn("Resource id not equal to entry fullUrl ({} vs. {}) at bundle index {}", new Object[]{idValue, fullUrl, bundleIndex});
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Resource id not equal to entry fullUrl (" + idValue + " vs. " + fullUrl + ") at bundle index " + bundleIndex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)out).build();
    }

    public Response forbiddenNotAllowed(String operation, Identity identity) {
        logger.warn("Operation {} forbidden for identity '{}'", (Object)operation, (Object)identity.getName());
        OperationOutcome out = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.FORBIDDEN, "Operation " + operation + " forbidden");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)out).build();
    }

    public Response notFound(String id, String resourceTypeName) {
        logger.warn("{} with id {} not found", (Object)resourceTypeName, (Object)id);
        OperationOutcome outcome = this.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " with id " + id + " not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)outcome).build();
    }

    public Response forbiddenNotValid(String operation, Identity identity, String resourceType, ValidationResult validationResult) {
        OperationOutcome outcome = new OperationOutcome();
        validationResult.populateOperationOutcome((IBaseOperationOutcome)outcome);
        logger.warn("Operation {} forbidden, {} resource not valid for user '{}'", new Object[]{operation, resourceType, identity.getName()});
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome).build();
    }

    public Response unableToGenerateSnapshot(StructureDefinition resource, Integer bundleIndex, List<ValidationMessage> messages) {
        if (bundleIndex == null) {
            logger.warn("Unable to generate StructureDefinition snapshot for profile with url {}, version {} and id {}: {}", new Object[]{resource.getUrl(), resource.getVersion(), resource.getId()});
        } else {
            logger.warn("Unable to generate StructureDefinition snapshot for profile with url {}, version {} and id {} at bundle index {}: {}", new Object[]{resource.getUrl(), resource.getVersion(), resource.getId(), bundleIndex});
        }
        OperationOutcome outcome = new OperationOutcome();
        messages.forEach(m -> outcome.addIssue().setSeverity(this.convert(m.getLevel())).setCode(this.convert(m.getType())).setDiagnostics(m.summary()));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build();
    }

    private OperationOutcome.IssueSeverity convert(ValidationMessage.IssueSeverity severity) {
        switch (severity) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
            case NULL: {
                return OperationOutcome.IssueSeverity.NULL;
            }
        }
        throw new RuntimeException("IssueSeverity " + severity + " not supported");
    }

    private OperationOutcome.IssueType convert(ValidationMessage.IssueType type) {
        switch (type) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case MULTIPLEMATCHES: {
                return OperationOutcome.IssueType.MULTIPLEMATCHES;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case DELETED: {
                return OperationOutcome.IssueType.DELETED;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
            case NULL: {
                return OperationOutcome.IssueType.NULL;
            }
        }
        throw new RuntimeException("IssueType " + type + " not supported");
    }

    static {
        PRIVATE_NO_CACHE_NO_TRANSFORM.setPrivate(true);
        PRIVATE_NO_CACHE_NO_TRANSFORM.setNoCache(true);
    }
}

