/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.HtmlGenerator;
import dev.dsf.fhir.adapter.ResourceHtmlGenerator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;

public class OrganizationHtmlGenerator
extends ResourceHtmlGenerator
implements HtmlGenerator<Organization> {
    private static final String EXTENSION_THUMBPRINT_URL = "http://dsf.dev/fhir/StructureDefinition/extension-certificate-thumbprint";
    private static final String CODE_SYSTEM_CONTACT_TYPE = "http://terminology.hl7.org/CodeSystem/contactentity-type";
    private static final String CODE_SYSTEM_CONTACT_TYPE_VALUE_ADMIN = "ADMIN";

    @Override
    public Class<Organization> getResourceType() {
        return Organization.class;
    }

    @Override
    public void writeHtml(URI resourceUri, Organization resource, OutputStreamWriter out) throws IOException {
        List<Reference> endpoints;
        List<String> thumbprints;
        List<String> identifiers;
        out.write("<div class=\"resource\">\n");
        out.write("<div class=\"row\" active=\"" + resource.getActive() + "\">\n");
        out.write("</div>\n");
        this.writeMeta((Resource)resource, out);
        this.writeRow("Active", String.valueOf(resource.getActive()), out);
        this.writeSectionHeader("Organization", out);
        if (resource.hasName()) {
            this.writeRow("Name", resource.getName(), out);
        }
        if (resource.hasAddress()) {
            this.writeRowWithAddress(resource.getAddressFirstRep(), out);
        }
        if (resource.hasTelecom()) {
            this.writeRowWithContacts(resource.getTelecom(), out);
        }
        if (!(identifiers = resource.getIdentifier().stream().map(i -> (i.hasSystem() ? i.getSystem() : "") + " | <b>" + (i.hasValue() ? i.getValue() : "") + "</b>").toList()).isEmpty()) {
            this.writeRowWithList("Identifiers", identifiers, out);
        }
        if (!(thumbprints = resource.getExtension().stream().filter(e -> EXTENSION_THUMBPRINT_URL.equals(e.getUrl()) && e.hasValue()).map(e -> e.getValue()).filter(t -> t instanceof StringType).map(t -> (StringType)t).filter(s -> s.hasValue()).map(s -> (String)s.getValue()).toList()).isEmpty()) {
            this.writeRowWithList("Thumbprints", thumbprints, out);
        }
        if (!(endpoints = resource.getEndpoint().stream().filter(Reference::hasReference).toList()).isEmpty()) {
            this.writeSectionHeader("Endpoints", out);
            for (int i2 = 0; i2 < endpoints.size(); ++i2) {
                this.writeRowWithLink("Endpoint " + (i2 + 1), ResourceType.Endpoint.name(), endpoints.get(i2).getReferenceElement().getIdPart(), out);
            }
        }
        List contacts = resource.getContact();
        for (Organization.OrganizationContactComponent contact : contacts) {
            boolean isAdmin = contact.getPurpose().getCoding().stream().anyMatch(c -> CODE_SYSTEM_CONTACT_TYPE.equals(c.getSystem()) && CODE_SYSTEM_CONTACT_TYPE_VALUE_ADMIN.equals(c.getCode()));
            if (!isAdmin || !contact.hasName() && !contact.hasAddress() && !contact.hasTelecom()) continue;
            this.writeSectionHeader("Admin Contact", out);
            if (contact.hasName()) {
                this.writeRow("Name", contact.getName().getNameAsSingleString() != null ? contact.getName().getNameAsSingleString() : "", out);
            }
            if (contact.hasAddress()) {
                this.writeRowWithAddress(resource.getAddressFirstRep(), out);
            }
            if (!contact.hasTelecom()) continue;
            this.writeRowWithContacts(contact.getTelecom(), out);
        }
        out.write("</div>\n");
    }

    private void writeRowWithAddress(Address address, OutputStreamWriter out) throws IOException {
        out.write("<div class=\"row\">\n");
        out.write("<label class=\"row-label\">Address</label>\n");
        for (StringType line : address.getLine()) {
            out.write("<div class=\"row-text\">" + (line.hasValue() ? (String)line.getValue() : "") + "</div>\n");
        }
        out.write("<div class=\"row-text\">" + (address.hasPostalCode() ? address.getPostalCode() : "") + " " + (address.hasCity() ? address.getCity() : "") + "</div>\n");
        out.write("<div class=\"row-text\">" + (address.hasCountry() ? address.getCountry() : "") + "</div>\n");
        out.write("</div>\n");
    }

    private void writeRowWithContacts(List<ContactPoint> contacts, OutputStreamWriter out) throws IOException {
        Optional<ContactPoint> eMail = contacts.stream().filter(t -> ContactPoint.ContactPointSystem.EMAIL.equals((Object)t.getSystem())).filter(ContactPoint::hasValue).findFirst();
        Optional<ContactPoint> phone = contacts.stream().filter(t -> ContactPoint.ContactPointSystem.PHONE.equals((Object)t.getSystem())).filter(ContactPoint::hasValue).findFirst();
        if (eMail.isPresent() || phone.isPresent()) {
            out.write("<div class=\"contact\">\n");
            if (eMail.isPresent()) {
                this.writeRowWithAdditionalRowClasses("eMail", eMail.get().getValue(), phone.isPresent() ? "contact-element-50 contact-element-margin" : "contact-element-100", out);
            }
            if (phone.isPresent()) {
                this.writeRowWithAdditionalRowClasses("Phone", phone.get().getValue(), eMail.isPresent() ? "contact-element-50" : "contact-element-100", out);
            }
            out.write("</div>\n");
        }
    }

    @Override
    public boolean isResourceSupported(URI resourceUri, Resource resource) {
        return resource != null && resource instanceof Organization;
    }
}

