/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.impl;

import ca.uhn.fhir.rest.api.Constants;
import dev.dsf.fhir.webservice.base.AbstractBasicService;
import dev.dsf.fhir.webservice.specification.StaticResourcesService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;

public class StaticResourcesServiceImpl
extends AbstractBasicService
implements StaticResourcesService {
    private static CacheControl NO_TRANSFORM = new CacheControl();
    private static CacheControl NO_CACHE_NO_TRANSFORM = new CacheControl();
    private static final Map<String, String> MIME_TYPE_BY_SUFFIX;
    private final AbstractCache cache;
    private final CacheControl cacheControl;

    public StaticResourcesServiceImpl(boolean cacheEnabled) {
        this.cache = cacheEnabled ? new Cache() : new NoCache();
        this.cacheControl = cacheEnabled ? NO_TRANSFORM : NO_CACHE_NO_TRANSFORM;
    }

    @Override
    public Response getFile(String fileName, UriInfo uri, HttpHeaders headers) {
        if (fileName == null || fileName.isBlank()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!MIME_TYPE_BY_SUFFIX.keySet().stream().anyMatch(key -> fileName.endsWith((String)key))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<CacheEntry> entry = this.cache.get(fileName);
        Optional<String> matchTag = Arrays.asList("If-None-Match", Constants.HEADER_IF_NONE_MATCH_LC).stream().map(name -> headers.getHeaderString(name)).filter(h -> h != null).findFirst();
        return entry.map(this.toNotModifiedOrOkResponse(matchTag.orElse(""))).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    private Function<CacheEntry, Response.ResponseBuilder> toNotModifiedOrOkResponse(String matchTag) {
        return entry -> {
            if (entry.getTag().getValue().equals(matchTag.replace("\"", ""))) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
            }
            return Response.ok((Object)entry.getData(), (MediaType)MediaType.valueOf((String)entry.getMimeType())).tag(entry.getTag()).cacheControl(this.cacheControl);
        };
    }

    static {
        NO_CACHE_NO_TRANSFORM.setNoCache(true);
        MIME_TYPE_BY_SUFFIX = Map.of("css", "text/css", "js", "text/javascript", "html", "text/html", "pdf", "application/pdf", "png", "image/png", "svg", "image/svg+xml", "jpg", "image/jpeg");
    }

    private static final class Cache
    extends AbstractCache {
        private final Map<String, SoftReference<CacheEntry>> entries = new HashMap<String, SoftReference<CacheEntry>>();

        private Cache() {
        }

        @Override
        Optional<CacheEntry> get(String fileName) {
            SoftReference<CacheEntry> entry = this.entries.get(fileName);
            if (entry == null || entry.get() == null) {
                return this.read(fileName);
            }
            return Optional.of(entry.get());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Optional<CacheEntry> read(String fileName) {
            try (InputStream stream = StaticResourcesServiceImpl.class.getResourceAsStream("/static/" + fileName);){
                if (stream == null) {
                    Optional<CacheEntry> optional2 = Optional.empty();
                    return optional2;
                }
                CacheEntry entry = this.read(stream, fileName);
                this.entries.put(fileName, new SoftReference<CacheEntry>(entry));
                Optional<CacheEntry> optional = Optional.of(entry);
                return optional;
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    private static final class NoCache
    extends AbstractCache {
        private NoCache() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Optional<CacheEntry> get(String fileName) {
            try (InputStream stream = StaticResourcesServiceImpl.class.getResourceAsStream("/static/" + fileName);){
                if (stream == null) {
                    Optional<CacheEntry> optional2 = Optional.empty();
                    return optional2;
                }
                Optional<CacheEntry> optional = Optional.of(this.read(stream, fileName));
                return optional;
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    private static abstract class AbstractCache {
        private AbstractCache() {
        }

        abstract Optional<CacheEntry> get(String var1);

        protected CacheEntry read(InputStream stream, String fileName) throws IOException {
            byte[] data = stream.readAllBytes();
            byte[] hash = this.hash(data);
            String mimeType = this.mimeType(fileName);
            return new CacheEntry(data, hash, mimeType);
        }

        private byte[] hash(byte[] data) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                return digest.digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        private String mimeType(String fileName) {
            String[] parts = fileName.split("\\.");
            return MIME_TYPE_BY_SUFFIX.get(parts[parts.length - 1]);
        }
    }

    private static final class CacheEntry {
        private final byte[] data;
        private final byte[] hash;
        private final String mimeType;

        CacheEntry(byte[] data, byte[] hash, String mimeType) {
            this.data = data;
            this.hash = hash;
            this.mimeType = mimeType;
        }

        byte[] getData() {
            return this.data;
        }

        EntityTag getTag() {
            return new EntityTag(Hex.encodeHexString((byte[])this.hash));
        }

        String getMimeType() {
            return this.mimeType;
        }
    }
}

