/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.impl;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.SummaryMode;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.ActivityDefinitionDate;
import dev.dsf.fhir.search.parameters.ActivityDefinitionIdentifier;
import dev.dsf.fhir.search.parameters.ActivityDefinitionName;
import dev.dsf.fhir.search.parameters.ActivityDefinitionStatus;
import dev.dsf.fhir.search.parameters.ActivityDefinitionUrl;
import dev.dsf.fhir.search.parameters.ActivityDefinitionVersion;
import dev.dsf.fhir.search.parameters.BinaryContentType;
import dev.dsf.fhir.search.parameters.BundleIdentifier;
import dev.dsf.fhir.search.parameters.CodeSystemDate;
import dev.dsf.fhir.search.parameters.CodeSystemIdentifier;
import dev.dsf.fhir.search.parameters.CodeSystemStatus;
import dev.dsf.fhir.search.parameters.CodeSystemUrl;
import dev.dsf.fhir.search.parameters.CodeSystemVersion;
import dev.dsf.fhir.search.parameters.DocumentReferenceIdentifier;
import dev.dsf.fhir.search.parameters.EndpointAddress;
import dev.dsf.fhir.search.parameters.EndpointIdentifier;
import dev.dsf.fhir.search.parameters.EndpointName;
import dev.dsf.fhir.search.parameters.EndpointOrganization;
import dev.dsf.fhir.search.parameters.EndpointStatus;
import dev.dsf.fhir.search.parameters.GroupIdentifier;
import dev.dsf.fhir.search.parameters.HealthcareServiceActive;
import dev.dsf.fhir.search.parameters.HealthcareServiceIdentifier;
import dev.dsf.fhir.search.parameters.LibraryDate;
import dev.dsf.fhir.search.parameters.LibraryIdentifier;
import dev.dsf.fhir.search.parameters.LibraryStatus;
import dev.dsf.fhir.search.parameters.LibraryUrl;
import dev.dsf.fhir.search.parameters.LibraryVersion;
import dev.dsf.fhir.search.parameters.LocationIdentifier;
import dev.dsf.fhir.search.parameters.MeasureDate;
import dev.dsf.fhir.search.parameters.MeasureDependsOn;
import dev.dsf.fhir.search.parameters.MeasureIdentifier;
import dev.dsf.fhir.search.parameters.MeasureReportIdentifier;
import dev.dsf.fhir.search.parameters.MeasureStatus;
import dev.dsf.fhir.search.parameters.MeasureUrl;
import dev.dsf.fhir.search.parameters.MeasureVersion;
import dev.dsf.fhir.search.parameters.NamingSystemDate;
import dev.dsf.fhir.search.parameters.NamingSystemName;
import dev.dsf.fhir.search.parameters.NamingSystemStatus;
import dev.dsf.fhir.search.parameters.OrganizationActive;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationActive;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationEndpoint;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationIdentifier;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationParticipatingOrganization;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationPrimaryOrganization;
import dev.dsf.fhir.search.parameters.OrganizationAffiliationRole;
import dev.dsf.fhir.search.parameters.OrganizationEndpoint;
import dev.dsf.fhir.search.parameters.OrganizationIdentifier;
import dev.dsf.fhir.search.parameters.OrganizationName;
import dev.dsf.fhir.search.parameters.OrganizationType;
import dev.dsf.fhir.search.parameters.PatientActive;
import dev.dsf.fhir.search.parameters.PatientIdentifier;
import dev.dsf.fhir.search.parameters.PractitionerActive;
import dev.dsf.fhir.search.parameters.PractitionerIdentifier;
import dev.dsf.fhir.search.parameters.PractitionerRoleActive;
import dev.dsf.fhir.search.parameters.PractitionerRoleIdentifier;
import dev.dsf.fhir.search.parameters.PractitionerRoleOrganization;
import dev.dsf.fhir.search.parameters.PractitionerRolePractitioner;
import dev.dsf.fhir.search.parameters.QuestionnaireDate;
import dev.dsf.fhir.search.parameters.QuestionnaireIdentifier;
import dev.dsf.fhir.search.parameters.QuestionnaireResponseAuthored;
import dev.dsf.fhir.search.parameters.QuestionnaireResponseIdentifier;
import dev.dsf.fhir.search.parameters.QuestionnaireResponseStatus;
import dev.dsf.fhir.search.parameters.QuestionnaireStatus;
import dev.dsf.fhir.search.parameters.QuestionnaireUrl;
import dev.dsf.fhir.search.parameters.QuestionnaireVersion;
import dev.dsf.fhir.search.parameters.ResearchStudyEnrollment;
import dev.dsf.fhir.search.parameters.ResearchStudyIdentifier;
import dev.dsf.fhir.search.parameters.ResearchStudyPrincipalInvestigator;
import dev.dsf.fhir.search.parameters.ResourceId;
import dev.dsf.fhir.search.parameters.ResourceLastUpdated;
import dev.dsf.fhir.search.parameters.ResourceProfile;
import dev.dsf.fhir.search.parameters.StructureDefinitionDate;
import dev.dsf.fhir.search.parameters.StructureDefinitionIdentifier;
import dev.dsf.fhir.search.parameters.StructureDefinitionStatus;
import dev.dsf.fhir.search.parameters.StructureDefinitionUrl;
import dev.dsf.fhir.search.parameters.StructureDefinitionVersion;
import dev.dsf.fhir.search.parameters.SubscriptionCriteria;
import dev.dsf.fhir.search.parameters.SubscriptionPayload;
import dev.dsf.fhir.search.parameters.SubscriptionStatus;
import dev.dsf.fhir.search.parameters.SubscriptionType;
import dev.dsf.fhir.search.parameters.TaskAuthoredOn;
import dev.dsf.fhir.search.parameters.TaskIdentifier;
import dev.dsf.fhir.search.parameters.TaskModified;
import dev.dsf.fhir.search.parameters.TaskRequester;
import dev.dsf.fhir.search.parameters.TaskStatus;
import dev.dsf.fhir.search.parameters.ValueSetDate;
import dev.dsf.fhir.search.parameters.ValueSetIdentifier;
import dev.dsf.fhir.search.parameters.ValueSetStatus;
import dev.dsf.fhir.search.parameters.ValueSetUrl;
import dev.dsf.fhir.search.parameters.ValueSetVersion;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.rev.include.EndpointOrganizationRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.OrganizationAffiliationParticipatingOrganizationRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.OrganizationAffiliationPrimaryOrganizationRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.OrganizationEndpointRevInclude;
import dev.dsf.fhir.search.parameters.rev.include.ResearchStudyEnrollmentRevInclude;
import dev.dsf.fhir.webservice.base.AbstractBasicService;
import dev.dsf.fhir.webservice.specification.ConformanceService;
import dev.dsf.tools.build.BuildInfoReader;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.codesystems.RestfulSecurityService;
import org.springframework.beans.factory.InitializingBean;

public class ConformanceServiceImpl
extends AbstractBasicService
implements ConformanceService,
InitializingBean {
    private final String serverBase;
    private final int defaultPageCount;
    private final BuildInfoReader buildInfoReader;
    private final ParameterConverter parameterConverter;
    private final IValidationSupport validationSupport;

    public ConformanceServiceImpl(String serverBase, int defaultPageCount, BuildInfoReader buildInfoReader, ParameterConverter parameterConverter, IValidationSupport validationSupport) {
        this.serverBase = serverBase;
        this.defaultPageCount = defaultPageCount;
        this.buildInfoReader = buildInfoReader;
        this.parameterConverter = parameterConverter;
        this.validationSupport = validationSupport;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.buildInfoReader, "buildInfoReader");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.validationSupport, "validationSupport");
    }

    @Override
    public Response getMetadata(String mode, UriInfo uri, HttpHeaders headers) {
        return Response.ok((Object)this.createCapabilityStatement(), (MediaType)this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    private String getVersion(BuildInfoReader buildInfoReader) {
        String branch = buildInfoReader.getBuildBranch();
        String number = buildInfoReader.getBuildNumber();
        number = number.length() >= 7 ? number.substring(0, 7) : number;
        String version = buildInfoReader.getProjectVersion();
        return version + " (" + branch + "/" + number + ")";
    }

    private CapabilityStatement createCapabilityStatement() {
        CapabilityStatement statement = new CapabilityStatement();
        statement.setStatus(Enumerations.PublicationStatus.ACTIVE);
        statement.setDate(this.buildInfoReader.getBuildDateAsDate());
        statement.setPublisher("DSF Developers");
        statement.setKind(CapabilityStatement.CapabilityStatementKind.INSTANCE);
        statement.setSoftware(new CapabilityStatement.CapabilityStatementSoftwareComponent());
        statement.getSoftware().setName("Data Sharing Framework");
        statement.getSoftware().setVersion(this.getVersion(this.buildInfoReader));
        statement.setImplementation(new CapabilityStatement.CapabilityStatementImplementationComponent());
        statement.getImplementation().setUrl(this.serverBase);
        statement.setFhirVersion(Enumerations.FHIRVersion._4_0_1);
        statement.setFormat(Arrays.asList(new CodeType("application/fhir+json"), new CodeType("application/fhir+xml")));
        CapabilityStatement.CapabilityStatementRestComponent rest = statement.addRest();
        rest.setMode(CapabilityStatement.RestfulCapabilityMode.SERVER);
        rest.getSecurity().setService(Collections.singletonList(new CodeableConcept().addCoding(new Coding(RestfulSecurityService.CERTIFICATES.getSystem(), RestfulSecurityService.CERTIFICATES.toCode(), RestfulSecurityService.CERTIFICATES.getDisplay()))));
        Extension websocketExtension = rest.addExtension();
        websocketExtension.setUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket");
        websocketExtension.setValue((Type)new UrlType(this.serverBase.replace("http", "ws") + "/ws"));
        List<Class> resources = Arrays.asList(ActivityDefinition.class, Binary.class, Bundle.class, CodeSystem.class, DocumentReference.class, Endpoint.class, Group.class, HealthcareService.class, Library.class, Location.class, Measure.class, MeasureReport.class, NamingSystem.class, Organization.class, OrganizationAffiliation.class, Patient.class, PractitionerRole.class, Practitioner.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, ResearchStudy.class, StructureDefinition.class, Subscription.class, Task.class, ValueSet.class);
        HashMap searchParameters = new HashMap();
        HashMap revIncludeParameters = new HashMap();
        searchParameters.put(ActivityDefinition.class, Arrays.asList(ActivityDefinitionDate.class, ActivityDefinitionUrl.class, ActivityDefinitionIdentifier.class, ActivityDefinitionVersion.class, ActivityDefinitionName.class, ActivityDefinitionStatus.class));
        searchParameters.put(Binary.class, Arrays.asList(BinaryContentType.class));
        searchParameters.put(Bundle.class, Arrays.asList(BundleIdentifier.class));
        searchParameters.put(CodeSystem.class, Arrays.asList(CodeSystemDate.class, CodeSystemIdentifier.class, CodeSystemUrl.class, CodeSystemVersion.class, CodeSystemStatus.class));
        searchParameters.put(DocumentReference.class, Arrays.asList(DocumentReferenceIdentifier.class));
        searchParameters.put(Endpoint.class, Arrays.asList(EndpointAddress.class, EndpointIdentifier.class, EndpointName.class, EndpointOrganization.class, EndpointStatus.class));
        revIncludeParameters.put(Endpoint.class, Arrays.asList(OrganizationEndpointRevInclude.class));
        searchParameters.put(Group.class, Arrays.asList(GroupIdentifier.class));
        revIncludeParameters.put(Group.class, Arrays.asList(ResearchStudyEnrollmentRevInclude.class));
        searchParameters.put(HealthcareService.class, Arrays.asList(HealthcareServiceActive.class, HealthcareServiceIdentifier.class));
        searchParameters.put(Library.class, Arrays.asList(LibraryDate.class, LibraryIdentifier.class, LibraryStatus.class, LibraryUrl.class, LibraryVersion.class));
        searchParameters.put(Location.class, Arrays.asList(LocationIdentifier.class));
        searchParameters.put(Measure.class, Arrays.asList(MeasureDate.class, MeasureDependsOn.class, MeasureIdentifier.class, MeasureStatus.class, MeasureUrl.class, MeasureVersion.class));
        searchParameters.put(MeasureReport.class, Arrays.asList(MeasureReportIdentifier.class));
        searchParameters.put(NamingSystem.class, Arrays.asList(NamingSystemDate.class, NamingSystemName.class, NamingSystemStatus.class));
        searchParameters.put(Organization.class, Arrays.asList(OrganizationActive.class, OrganizationEndpoint.class, OrganizationIdentifier.class, OrganizationName.class, OrganizationType.class));
        revIncludeParameters.put(Organization.class, Arrays.asList(EndpointOrganizationRevInclude.class, OrganizationAffiliationParticipatingOrganizationRevInclude.class, OrganizationAffiliationPrimaryOrganizationRevInclude.class));
        searchParameters.put(OrganizationAffiliation.class, Arrays.asList(OrganizationAffiliationActive.class, OrganizationAffiliationEndpoint.class, OrganizationAffiliationIdentifier.class, OrganizationAffiliationParticipatingOrganization.class, OrganizationAffiliationPrimaryOrganization.class, OrganizationAffiliationRole.class));
        searchParameters.put(Patient.class, Arrays.asList(PatientActive.class, PatientIdentifier.class));
        searchParameters.put(Practitioner.class, Arrays.asList(PractitionerActive.class, PractitionerIdentifier.class));
        searchParameters.put(PractitionerRole.class, Arrays.asList(PractitionerRoleActive.class, PractitionerRoleIdentifier.class, PractitionerRoleOrganization.class, PractitionerRolePractitioner.class));
        searchParameters.put(Questionnaire.class, Arrays.asList(QuestionnaireDate.class, QuestionnaireIdentifier.class, QuestionnaireStatus.class, QuestionnaireUrl.class, QuestionnaireVersion.class));
        searchParameters.put(QuestionnaireResponse.class, Arrays.asList(QuestionnaireResponseAuthored.class, QuestionnaireResponseIdentifier.class, QuestionnaireResponseStatus.class));
        searchParameters.put(ResearchStudy.class, Arrays.asList(ResearchStudyIdentifier.class, ResearchStudyEnrollment.class, ResearchStudyPrincipalInvestigator.class));
        searchParameters.put(StructureDefinition.class, Arrays.asList(StructureDefinitionDate.class, StructureDefinitionIdentifier.class, StructureDefinitionStatus.class, StructureDefinitionUrl.class, StructureDefinitionVersion.class));
        searchParameters.put(Subscription.class, Arrays.asList(SubscriptionCriteria.class, SubscriptionPayload.class, SubscriptionStatus.class, SubscriptionType.class));
        searchParameters.put(Task.class, Arrays.asList(TaskAuthoredOn.class, TaskIdentifier.class, TaskModified.class, TaskRequester.class, TaskStatus.class));
        searchParameters.put(ValueSet.class, Arrays.asList(ValueSetDate.class, ValueSetIdentifier.class, ValueSetUrl.class, ValueSetVersion.class, ValueSetStatus.class));
        HashMap<Class<StructureDefinition>, List<Object>> operations = new HashMap<Class<StructureDefinition>, List<Object>>();
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent snapshotOperation = this.createOperation("snapshot", "http://hl7.org/fhir/OperationDefinition/StructureDefinition-snapshot", "Generates a StructureDefinition instance with a snapshot, based on a differential in a specified StructureDefinition");
        operations.put(StructureDefinition.class, Arrays.asList(snapshotOperation));
        List<Class> standardSortableSearchParameters = Arrays.asList(ResourceId.class, ResourceLastUpdated.class, ResourceProfile.class);
        List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> standardOperations = Arrays.asList(this.createValidateOperation());
        Map profileUrlsByResource = this.validationSupport.fetchAllStructureDefinitions().stream().filter(r -> r instanceof StructureDefinition).map(r -> (StructureDefinition)r).filter(s -> StructureDefinition.StructureDefinitionKind.RESOURCE.equals((Object)s.getKind()) && !s.getAbstract() && EnumSet.of(Enumerations.PublicationStatus.ACTIVE, Enumerations.PublicationStatus.DRAFT).contains(s.getStatus()) && !s.getUrl().contains("hl7.org")).map(StructureDefinitionDistinctByUrl::new).distinct().sorted().map(StructureDefinitionDistinctByUrl::get).collect(Collectors.groupingBy(StructureDefinition::getType, Collectors.mapping(s -> new CanonicalType(s.getUrl()), Collectors.toList())));
        for (Class resource : resources) {
            CapabilityStatement.CapabilityStatementRestResourceComponent r2 = rest.addResource();
            r2.setVersioning(CapabilityStatement.ResourceVersionPolicy.VERSIONED);
            r2.setReadHistory(true);
            r2.setUpdateCreate(false);
            r2.setConditionalCreate(true);
            r2.setConditionalRead(CapabilityStatement.ConditionalReadStatus.FULLSUPPORT);
            r2.setConditionalUpdate(true);
            r2.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.SINGLE);
            r2.addReferencePolicy(CapabilityStatement.ReferenceHandlingPolicy.LITERAL);
            r2.addReferencePolicy(CapabilityStatement.ReferenceHandlingPolicy.LOGICAL);
            ResourceDef resourceDefAnnotation = resource.getAnnotation(ResourceDef.class);
            r2.setType(resourceDefAnnotation.name());
            r2.setProfile(resourceDefAnnotation.profile());
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.CREATE);
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.READ);
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.VREAD);
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.UPDATE);
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.DELETE);
            r2.addInteraction().setCode(CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
            List resourceSearchParameters = searchParameters.getOrDefault(resource, Collections.emptyList());
            resourceSearchParameters.stream().map(this::createSearchParameter).sorted(Comparator.comparing(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent::getName)).forEach(arg_0 -> ((CapabilityStatement.CapabilityStatementRestResourceComponent)r2).addSearchParam(arg_0));
            r2.addSearchParam(this.createCountParameter(this.defaultPageCount));
            r2.addSearchParam(this.createFormatParameter());
            r2.addSearchParam(this.createIdParameter());
            List<IncludeParameterDefinition> includes = resourceSearchParameters.stream().map(p -> p.getAnnotation(IncludeParameterDefinition.class)).filter(def -> def != null).collect(Collectors.toList());
            if (!includes.isEmpty()) {
                r2.addSearchParam(this.createIncludeParameter(includes));
                r2.setSearchInclude(includes.stream().flatMap(this::toIncludeParameterNames).sorted().map(StringType::new).collect(Collectors.toList()));
            }
            r2.addSearchParam(this.createLastUpdatedParameter());
            r2.addSearchParam(this.createPageParameter());
            r2.addSearchParam(this.createPrettyParameter());
            r2.addSearchParam(this.createSummaryParameter());
            r2.addSearchParam(this.createProfileParameter());
            r2.addSearchParam(this.createSinceParameter());
            r2.addSearchParam(this.createAtParameter());
            List resourceRevIncludeParameters = revIncludeParameters.getOrDefault(resource, Collections.emptyList());
            List<IncludeParameterDefinition> revIncludes = resourceRevIncludeParameters.stream().map(p -> p.getAnnotation(IncludeParameterDefinition.class)).filter(def -> def != null).collect(Collectors.toList());
            if (!revIncludes.isEmpty()) {
                r2.addSearchParam(this.createRevIncludeParameter(revIncludes));
                r2.setSearchRevInclude(revIncludes.stream().flatMap(this::toIncludeParameterNames).sorted().map(StringType::new).collect(Collectors.toList()));
            }
            r2.addSearchParam(this.createSortParameter(Stream.concat(standardSortableSearchParameters.stream(), resourceSearchParameters.stream())));
            r2.getSearchParam().sort(Comparator.comparing(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent::getName));
            operations.getOrDefault(resource, Collections.emptyList()).forEach(arg_0 -> ((CapabilityStatement.CapabilityStatementRestResourceComponent)r2).addOperation(arg_0));
            standardOperations.forEach(arg_0 -> ((CapabilityStatement.CapabilityStatementRestResourceComponent)r2).addOperation(arg_0));
            r2.setSupportedProfile(profileUrlsByResource.getOrDefault(resourceDefAnnotation.name(), Collections.emptyList()));
        }
        return statement;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createIncludeParameter(List<IncludeParameterDefinition> includes) {
        String values = includes.stream().flatMap(this::toIncludeParameterNames).sorted().collect(Collectors.joining(", ", "[", "]"));
        return this.createSearchParameter("_include", "", Enumerations.SearchParamType.SPECIAL, "Additional resources to return, allowed values: " + values + " (use one _include parameter for every resource to include)");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createRevIncludeParameter(List<IncludeParameterDefinition> revIncludes) {
        String values = revIncludes.stream().flatMap(this::toIncludeParameterNames).sorted().collect(Collectors.joining(", ", "[", "]"));
        return this.createSearchParameter("_revinclude", "", Enumerations.SearchParamType.SPECIAL, "Additional resources to return, allowed values: " + values + " (use one _revinclude parameter for every resource to include)");
    }

    private Stream<String> toIncludeParameterNames(IncludeParameterDefinition def) {
        return Arrays.stream(def.targetResourceTypes()).map(target -> target.getAnnotation(ResourceDef.class).name()).map(target -> def.resourceType().getAnnotation(ResourceDef.class).name() + ":" + def.parameterName() + ":" + target);
    }

    private CapabilityStatement.CapabilityStatementRestResourceOperationComponent createValidateOperation() {
        return this.createOperation("validate", "http://hl7.org/fhir/OperationDefinition/Resource-validate", "The validate operation checks whether the attached content would be acceptable either generally, as a create, an update or as a delete to an existing resource. The action the server takes depends on the mode parameter");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createSortParameter(Stream<Class<? extends AbstractSearchParameter>> parameters) {
        String values = parameters.map(p -> p.getAnnotation(SearchQueryParameter.SearchParameterDefinition.class)).map(def -> def.name()).sorted().collect(Collectors.joining(", ", "[", "]"));
        return this.createSearchParameter("_sort", "", Enumerations.SearchParamType.SPECIAL, "Specify the returned order, allowed values: " + values + " (one or multiple as comma separated string), prefix with '-' for reversed order");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createLastUpdatedParameter() {
        return this.createSearchParameter(ResourceLastUpdated.class);
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createPageParameter() {
        return this.createSearchParameter("_page", "", Enumerations.SearchParamType.NUMBER, "Specify the page number, 1 if not specified");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createCountParameter(int defaultPageCount) {
        return this.createSearchParameter("_count", "", Enumerations.SearchParamType.NUMBER, "Specify the numer of returned resources per page, " + defaultPageCount + " if not specified");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createAtParameter() {
        return this.createSearchParameter("_at", "", Enumerations.SearchParamType.DATE, "Only include resource versions that were current at some point during the time period specified in the date time value");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createSinceParameter() {
        return this.createSearchParameter("_since", "", Enumerations.SearchParamType.SPECIAL, "Only include resource versions that were created at or after the given instant in time");
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createFormatParameter() {
        String formatValues = Stream.of(Stream.of("json"), ParameterConverter.JSON_FORMATS.stream(), Stream.of("xml"), ParameterConverter.XML_FORMATS.stream()).flatMap(Function.identity()).collect(Collectors.joining(", ", "[", "]"));
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createFormatParameter = this.createSearchParameter("_format", "", Enumerations.SearchParamType.SPECIAL, "Specify the returned format of the payload response, allowed values: " + formatValues);
        return createFormatParameter;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createIdParameter() {
        return this.createSearchParameter(ResourceId.class);
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createPrettyParameter() {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createFormatParameter = this.createSearchParameter("_pretty", "", Enumerations.SearchParamType.SPECIAL, "Pretty printed response for human convenience, allowed values: [true, false]");
        return createFormatParameter;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createSummaryParameter() {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createFormatParameter = this.createSearchParameter("_summary", "", Enumerations.SearchParamType.SPECIAL, "Predefined short form of the resource, allowed values: " + Arrays.stream(SummaryMode.values()).map(SummaryMode::toString).collect(Collectors.joining(", ", "[", "]")));
        return createFormatParameter;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createProfileParameter() {
        return this.createSearchParameter(ResourceProfile.class);
    }

    private CapabilityStatement.CapabilityStatementRestResourceOperationComponent createOperation(String name, String definition, String documentation) {
        return new CapabilityStatement.CapabilityStatementRestResourceOperationComponent().setName(name).setDefinition(definition).setDocumentation(documentation);
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createSearchParameter(Class<?> parameter) {
        SearchQueryParameter.SearchParameterDefinition d = parameter.getAnnotation(SearchQueryParameter.SearchParameterDefinition.class);
        return this.createSearchParameter(d.name(), d.definition(), d.type(), d.documentation());
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent createSearchParameter(String name, String definition, Enumerations.SearchParamType type, String documentation) {
        return new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent().setName(name).setDefinition(definition).setType(type).setDocumentation(documentation);
    }

    private static final class StructureDefinitionDistinctByUrl
    implements Comparable<StructureDefinitionDistinctByUrl> {
        final StructureDefinition structureDefinition;
        final String url;

        public StructureDefinitionDistinctByUrl(StructureDefinition structureDefinition) {
            this.structureDefinition = structureDefinition;
            this.url = structureDefinition.getUrl();
        }

        public StructureDefinition get() {
            return this.structureDefinition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StructureDefinitionDistinctByUrl other = (StructureDefinitionDistinctByUrl)obj;
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        @Override
        public int compareTo(StructureDefinitionDistinctByUrl o) {
            return this.url.compareTo(o.url);
        }
    }
}

