/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.spring.config.EventConfig;
import dev.dsf.fhir.websocket.ServerEndpoint;
import dev.dsf.fhir.websocket.ServerEndpointRegistrationForAuthentication;
import jakarta.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.jakarta.server.config.ContainerDefaultConfigurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
public class WebsocketConfig {
    @Autowired
    private EventConfig eventConfig;

    @Bean
    public ServerEndpoint subscriptionEndpoint() {
        return new ServerEndpoint(this.eventConfig.webSocketSubscriptionManager());
    }

    @Bean
    public ServerEndpointRegistration subscriptionEndpointRegistration() {
        return new ServerEndpointRegistrationForAuthentication(this.containerDefaultConfigurator(), "/ws", this.subscriptionEndpoint());
    }

    @Bean
    public ServerEndpointExporter endpointExporter() {
        return new ServerEndpointExporter();
    }

    @Bean
    public ServerEndpointConfig.Configurator containerDefaultConfigurator() {
        return new ContainerDefaultConfigurator();
    }
}

