/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.service.InitialDataMigrator;
import dev.dsf.fhir.service.InitialDataMigratorImpl;
import dev.dsf.fhir.service.migration.MigrationJob;
import dev.dsf.fhir.spring.config.DaoConfig;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
public class InitialDataMigratorConfig {
    @Autowired
    public DaoConfig daoConfig;

    @Bean
    public List<MigrationJob> migrationJobs() {
        return Collections.emptyList();
    }

    @Bean
    public InitialDataMigrator initialDataMigrator() {
        return new InitialDataMigratorImpl(this.migrationJobs());
    }

    @Order(value=-2147483647)
    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent(ContextRefreshedEvent event) throws Exception {
        this.initialDataMigrator().execute();
    }
}

