/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractTokenParameter<R extends Resource>
extends AbstractSearchParameter<R> {
    protected TokenValueAndSearchType valueAndType;

    public static List<String> getNameModifiers() {
        return List.of(":not");
    }

    public AbstractTokenParameter(String parameterName) {
        super(parameterName);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        this.valueAndType = TokenValueAndSearchType.fromParamValue(this.parameterName, queryParameterName, queryParameterValue);
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return switch (this.valueAndType.type) {
            case TokenSearchType.CODE -> this.valueAndType.codeValue;
            case TokenSearchType.CODE_AND_SYSTEM -> this.valueAndType.systemValue + "|" + this.valueAndType.codeValue;
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> "|" + this.valueAndType.codeValue;
            case TokenSearchType.SYSTEM -> this.valueAndType.systemValue + "|";
            default -> throw new IllegalArgumentException("Unexpected " + TokenSearchType.class.getName() + " value: " + this.valueAndType.type);
        };
    }

    protected boolean codingMatches(List<CodeableConcept> codes) {
        return codes.stream().flatMap(c -> c.getCoding().stream()).anyMatch(c -> this.valueAndType.negated ? !AbstractTokenParameter.codingMatches(this.valueAndType, c) : AbstractTokenParameter.codingMatches(this.valueAndType, c));
    }

    public static boolean codingMatches(TokenValueAndSearchType valueAndType, Coding coding) {
        return switch (valueAndType.type) {
            case TokenSearchType.CODE -> Objects.equals(valueAndType.codeValue, coding.getCode());
            case TokenSearchType.CODE_AND_SYSTEM -> {
                if (Objects.equals(valueAndType.codeValue, coding.getCode()) && Objects.equals(valueAndType.systemValue, coding.getSystem())) {
                    yield true;
                }
                yield false;
            }
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> {
                if (Objects.equals(valueAndType.codeValue, coding.getCode()) && (coding.getSystem() == null || coding.getSystem().isBlank())) {
                    yield true;
                }
                yield false;
            }
            case TokenSearchType.SYSTEM -> Objects.equals(valueAndType.systemValue, coding.getSystem());
            default -> false;
        };
    }
}

