/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import ca.uhn.fhir.parser.DataFormatException;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.postgresql.util.PGobject;

@SearchQueryParameter.SearchParameterDefinition(name="_id", definition="http://hl7.org/fhir/SearchParameter/Resource-id", type=Enumerations.SearchParamType.STRING, documentation="Logical id of this resource")
public class ResourceId<R extends Resource>
extends AbstractSearchParameter<R> {
    public static final String PARAMETER_NAME = "_id";
    private final String resourceIdColumn;
    private UUID id;

    public ResourceId(String resourceIdColumn) {
        super(PARAMETER_NAME);
        this.resourceIdColumn = resourceIdColumn;
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        this.id = this.toId(errors, queryParameterValue);
    }

    private UUID toId(List<? super SearchQueryParameterError> errors, String value) {
        if (value.isBlank()) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_NAME, value));
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_NAME, value, e));
            return null;
        }
    }

    @Override
    public boolean isDefined() {
        return this.id != null;
    }

    @Override
    public String getFilterQuery() {
        return this.resourceIdColumn + " = ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setObject(parameterIndex, this.asUuidPgObject(this.id));
    }

    private PGobject asUuidPgObject(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            PGobject o = new PGobject();
            o.setType("UUID");
            o.setValue(uuid.toString());
            return o;
        }
        catch (DataFormatException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return PARAMETER_NAME;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.id.toString();
    }

    @Override
    public boolean matches(Resource resource) {
        if (this.isDefined()) {
            return Objects.equals(resource.getId(), this.id.toString());
        }
        throw this.notDefined();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceIdColumn + sortDirectionWithSpacePrefix;
    }
}

