/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="status", definition="http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status", type=Enumerations.SearchParamType.TOKEN, documentation="The status of the questionnaire response")
public class QuestionnaireResponseStatus
extends AbstractTokenParameter<QuestionnaireResponse> {
    public static final String PARAMETER_NAME = "status";
    public static final String RESOURCE_COLUMN = "questionnaire_response";
    private QuestionnaireResponse.QuestionnaireResponseStatus status;

    public QuestionnaireResponseStatus() {
        super(PARAMETER_NAME);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.status = this.toStatus(errors, this.valueAndType.codeValue, queryParameterValue);
        }
    }

    private QuestionnaireResponse.QuestionnaireResponseStatus toStatus(List<? super SearchQueryParameterError> errors, String status, String queryParameterValue) {
        if (status == null || status.isBlank()) {
            return null;
        }
        try {
            return QuestionnaireResponse.QuestionnaireResponseStatus.fromCode((String)status);
        }
        catch (FHIRException e) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue, (Exception)((Object)e)));
            return null;
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.status != null;
    }

    @Override
    public String getFilterQuery() {
        return "questionnaire_response->>'status' " + (this.valueAndType.negated ? "<>" : "=") + " ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.status.toCode());
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.status.toCode();
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof QuestionnaireResponse)) {
            return false;
        }
        if (this.valueAndType.negated) {
            return !Objects.equals(((QuestionnaireResponse)resource).getStatus(), this.status);
        }
        return Objects.equals(((QuestionnaireResponse)resource).getStatus(), this.status);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "questionnaire_response->>'status'" + sortDirectionWithSpacePrefix;
    }
}

