/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Practitioner-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="A practitioner's Identifier")
public class PractitionerIdentifier
extends AbstractIdentifierParameter<Practitioner> {
    public static final String RESOURCE_COLUMN = "practitioner";

    public PractitionerIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Practitioner)) {
            return false;
        }
        Practitioner p = (Practitioner)resource;
        return this.identifierMatches(p.getIdentifier());
    }
}

