/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Organization-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="Any identifier for the organization (not the accreditation issuer's identifier)")
public class OrganizationIdentifier
extends AbstractIdentifierParameter<Organization> {
    public static final String RESOURCE_COLUMN = "organization";

    public OrganizationIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)resource;
        return this.identifierMatches(o.getIdentifier());
    }
}

