/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.BinaryDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Resource;

public class BinaryAuthorizationRule
extends AbstractMetaTagAuthorizationRule<Binary, BinaryDao> {
    private final Map<Class<? extends Resource>, AuthorizationRule<?>> rules;

    public BinaryAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter, AuthorizationRule<?> ... supportedSecurityContextRules) {
        super(Binary.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
        this.rules = Arrays.stream(supportedSecurityContextRules).collect(Collectors.toMap(AuthorizationRule::getResourceType, Function.identity()));
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, Binary newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, Binary newResource) {
        return this.newResourceOk(connection, identity, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Identity identity, Binary newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean hasValidReadAccessTag = this.hasValidReadAccessTag(connection, (Resource)newResource);
        boolean hasValidSecurityContext = this.hasValidSecurityContext(connection, identity, newResource);
        if (!hasValidReadAccessTag && !hasValidSecurityContext) {
            errors.add("Binary is missing a valid read access tag or a valid securityContext");
        }
        if (hasValidReadAccessTag && hasValidSecurityContext) {
            errors.add("Binary cannot have a valid read access tag and a valid securityContext");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private boolean hasValidSecurityContext(Connection connection, Identity identity, Binary newResource) {
        if (newResource != null && newResource.hasSecurityContext()) {
            Optional<ResourceReference> ref = this.createIfLiteralInternalOrLogicalReference("Binary.securityContext", newResource.getSecurityContext(), new Class[0]);
            Optional securityContextOpt = ref.flatMap(r -> this.referenceResolver.resolveReference(identity, (ResourceReference)r, connection));
            return securityContextOpt.isPresent() && this.rules.containsKey(((Resource)securityContextOpt.get()).getClass());
        }
        return false;
    }

    @Override
    protected boolean resourceExists(Connection connection, Binary newResource) {
        return false;
    }

    @Override
    protected boolean modificationsOk(Connection connection, Binary oldResource, Binary newResource) {
        return true;
    }
}

