/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.secure;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import dev.dsf.fhir.validation.ResourceValidator;
import dev.dsf.fhir.webservice.secure.AbstractServiceSecure;
import dev.dsf.fhir.webservice.specification.BasicResourceService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractResourceServiceSecure<D extends ResourceDao<R>, R extends Resource, S extends BasicResourceService<R>>
extends AbstractServiceSecure<S>
implements BasicResourceService<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceServiceSecure.class);
    protected final ReferenceCleaner referenceCleaner;
    protected final ReferenceExtractor referenceExtractor;
    protected final Class<R> resourceType;
    protected final String resourceTypeName;
    protected final String serverBase;
    protected final D dao;
    protected final ExceptionHandler exceptionHandler;
    protected final ParameterConverter parameterConverter;
    protected final AuthorizationRule<R> authorizationRule;
    protected final ResourceValidator resourceValidator;

    public AbstractResourceServiceSecure(S delegate, String serverBase, ResponseGenerator responseGenerator, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, ReferenceExtractor referenceExtractor, Class<R> resourceType, D dao, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, AuthorizationRule<R> authorizationRule, ResourceValidator resourceValidator) {
        super(delegate, serverBase, responseGenerator, referenceResolver);
        this.referenceCleaner = referenceCleaner;
        this.referenceExtractor = referenceExtractor;
        this.resourceType = resourceType;
        this.resourceTypeName = resourceType.getAnnotation(ResourceDef.class).name();
        this.serverBase = serverBase;
        this.dao = dao;
        this.exceptionHandler = exceptionHandler;
        this.parameterConverter = parameterConverter;
        this.authorizationRule = authorizationRule;
        this.resourceValidator = resourceValidator;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.referenceExtractor, "referenceExtractor");
        Objects.requireNonNull(this.resourceType, "resourceType");
        Objects.requireNonNull(this.resourceTypeName, "resourceTypeName");
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.dao, "dao");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.authorizationRule, "authorizationRule");
        Objects.requireNonNull(this.resourceValidator, "resourceValidator");
    }

    private String toValidationLogMessage(ValidationResult validationResult) {
        return validationResult.getMessages().stream().map(m -> m.getLocationString() + " " + m.getLocationLine() + ":" + m.getLocationCol() + " - " + m.getSeverity() + ": " + m.getMessage()).collect(Collectors.joining(", ", "[", "]"));
    }

    private Response withResourceValidation(R resource, UriInfo uri, HttpHeaders headers, String method, Supplier<Response> delegate) {
        this.referenceCleaner.cleanReferenceResourcesIfBundle(resource);
        ValidationResult validationResult = this.resourceValidator.validate(resource);
        if (validationResult.getMessages().stream().anyMatch(m -> ResultSeverityEnum.ERROR.equals((Object)m.getSeverity()) || ResultSeverityEnum.FATAL.equals((Object)m.getSeverity()))) {
            logger.warn("{} of {} unauthorized, resource not valid: {}", new Object[]{method, resource.fhirType(), this.toValidationLogMessage(validationResult)});
            OperationOutcome outcome = new OperationOutcome();
            validationResult.populateOperationOutcome((IBaseOperationOutcome)outcome);
            return this.responseGenerator.response(Response.Status.FORBIDDEN, (Resource)outcome, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
        }
        if (!validationResult.getMessages().isEmpty()) {
            logger.warn("Resource {} validated with messages: {}", (Object)resource.fhirType(), (Object)this.toValidationLogMessage(validationResult));
        }
        return delegate.get();
    }

    @Override
    public Response create(R resource, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        this.resolveLiteralInternalRelatedArtifactOrAttachmentUrls(resource);
        Optional<String> reasonCreateAllowed = this.authorizationRule.reasonCreateAllowed(this.getCurrentIdentity(), resource);
        if (reasonCreateAllowed.isEmpty()) {
            audit.info("Create of resource {} denied for user '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.forbidden("create");
        }
        return this.withResourceValidation(resource, uri, headers, "Create", () -> {
            audit.info("Create of resource {} allowed for user '{}', reason: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), reasonCreateAllowed.get()});
            Response created = this.logResultStatus(() -> ((BasicResourceService)this.delegate).create(resource, uri, headers), status -> audit.info("Create of resource {} for user '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("Create of resource {} for user '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
            if (created.hasEntity() && !this.resourceType.isInstance(created.getEntity()) && !(created.getEntity() instanceof OperationOutcome)) {
                logger.warn("Create returned with entity of type {}", (Object)created.getEntity().getClass().getName());
            } else if (!created.hasEntity() && !PreferReturnType.MINIMAL.equals((Object)this.parameterConverter.getPreferReturn(headers))) {
                logger.warn("Create returned with status {}, but no entity", (Object)created.getStatus());
            }
            return created;
        });
    }

    private void resolveLiteralInternalRelatedArtifactOrAttachmentUrls(R resource) {
        if (resource == null) {
            return;
        }
        this.referenceExtractor.getReferences(resource).filter(ref -> ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_INTERNAL_URL.equals((Object)ref.getType(this.serverBase)) || ResourceReference.ReferenceType.ATTACHMENT_LITERAL_INTERNAL_URL.equals((Object)ref.getType(this.serverBase))).forEach(this::resolveLiteralInternalRelatedArtifactOrAttachmentUrl);
    }

    private void resolveLiteralInternalRelatedArtifactOrAttachmentUrl(ResourceReference reference) {
        if (reference.hasRelatedArtifact() || reference.hasAttachment()) {
            IdType newId = new IdType(reference.getValue());
            String absoluteUrl = newId.withServerBase(this.serverBase, newId.getResourceType()).getValue();
            if (reference.hasRelatedArtifact()) {
                reference.getRelatedArtifact().setUrl(absoluteUrl);
            } else if (reference.hasAttachment()) {
                reference.getAttachment().setUrl(absoluteUrl);
            }
        }
    }

    @Override
    public Response read(String id, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Response read = ((BasicResourceService)this.delegate).read(id, uri, headers);
        if (read.hasEntity() && this.resourceType.isInstance(read.getEntity())) {
            Resource entity = (Resource)this.resourceType.cast(read.getEntity());
            String entityId = entity.getIdElement().getIdPart();
            long entityVersion = entity.getIdElement().getVersionIdPartAsLong();
            Optional<String> reasonReadAllowed = this.authorizationRule.reasonReadAllowed(this.getCurrentIdentity(), entity);
            if (reasonReadAllowed.isEmpty()) {
                audit.info("Read of {}/{}/_history/{} denied for identity '{}'", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName()});
                return this.forbidden("read");
            }
            audit.info("Read of {}/{}/_history/{} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), reasonReadAllowed.get()});
            return this.logResultStatus(() -> {
                if (Response.Status.NOT_MODIFIED.getStatusCode() == read.getStatus()) {
                    return Response.notModified((EntityTag)read.getEntityTag()).lastModified(entity.getMeta().getLastUpdated()).build();
                }
                return read;
            }, status -> audit.info("Read of {}/{}/_history/{} for identity '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()}), status -> audit.info("Read of {}/{}/_history/{} for identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()}));
        }
        if (read.hasEntity() && read.getEntity() instanceof OperationOutcome) {
            audit.info("Read of {} for identity '{}' returned with OperationOutcome, status {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()});
            logger.info("Returning with OperationOutcome, status {} {}", (Object)read.getStatusInfo().getStatusCode(), (Object)read.getStatusInfo().getReasonPhrase());
            return read;
        }
        if (read.hasEntity()) {
            audit.info("Read of {} denied for identity '{}', not a {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), this.resourceTypeName});
            return this.forbidden("read");
        }
        audit.info("Read of {} for identity '{}' returned without entity, status {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), read.getStatus()});
        logger.info("Returning with status {}, but no entity", (Object)read.getStatusInfo().getStatusCode(), (Object)read.getStatusInfo().getReasonPhrase());
        return read;
    }

    @Override
    public Response vread(String id, long version, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Response read = ((BasicResourceService)this.delegate).vread(id, version, uri, headers);
        if (read.hasEntity() && this.resourceType.isInstance(read.getEntity())) {
            Resource entity = (Resource)this.resourceType.cast(read.getEntity());
            String entityId = entity.getIdElement().getIdPart();
            long entityVersion = entity.getIdElement().getVersionIdPartAsLong();
            Optional<String> reasonReadAllowed = this.authorizationRule.reasonReadAllowed(this.getCurrentIdentity(), entity);
            if (reasonReadAllowed.isEmpty()) {
                audit.info("Read of {}/{}/_history/{} denied for identity '{}'", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName()});
                return this.forbidden("read");
            }
            audit.info("Read of {}/{}/_history/{} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), reasonReadAllowed.get()});
            return this.logResultStatus(() -> {
                if (Response.Status.NOT_MODIFIED.getStatusCode() == read.getStatus()) {
                    return Response.notModified((EntityTag)read.getEntityTag()).lastModified(entity.getMeta().getLastUpdated()).build();
                }
                return read;
            }, status -> audit.info("Read of {}/{}/_history/{} for identity '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()}), status -> audit.info("Read of {}/{}/_history/{} for identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, entityId, entityVersion, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()}));
        }
        if (read.hasEntity() && read.getEntity() instanceof OperationOutcome) {
            audit.info("Read of {} for identity '{}' returned with OperationOutcome, status: {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()});
            logger.info("Returning with OperationOutcome, status {}", (Object)read.getStatusInfo().getStatusCode(), (Object)read.getStatusInfo().getReasonPhrase());
            return read;
        }
        if (read.hasEntity()) {
            audit.info("Read of {} denied for identity '{}', not a {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), this.resourceTypeName});
            return this.forbidden("read");
        }
        audit.info("Read of {} for identity '{}' returned without entity, status: {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), read.getStatusInfo().getStatusCode(), read.getStatusInfo().getReasonPhrase()});
        logger.info("Returning with status {} {}, but no entity", (Object)read.getStatusInfo().getStatusCode(), (Object)read.getStatusInfo().getReasonPhrase());
        return read;
    }

    @Override
    public Response history(UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional<String> reasonHistoryAllowed = this.authorizationRule.reasonHistoryAllowed(this.getCurrentIdentity());
        if (reasonHistoryAllowed.isEmpty()) {
            audit.info("History of {} denied for identity '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.forbidden("history");
        }
        audit.info("History of {} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), reasonHistoryAllowed.get()});
        return this.logResultStatus(() -> ((BasicResourceService)this.delegate).history(uri, headers), status -> audit.info("History of {} for identity '{}' successful: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("History of {} for identity '{}' failed: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
    }

    @Override
    public Response history(String id, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional<String> reasonHistoryAllowed = this.authorizationRule.reasonHistoryAllowed(this.getCurrentIdentity());
        if (reasonHistoryAllowed.isEmpty()) {
            audit.info("History of {} denied for identity '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.forbidden("history");
        }
        audit.info("History of {} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), reasonHistoryAllowed.get()});
        return this.logResultStatus(() -> ((BasicResourceService)this.delegate).history(id, uri, headers), status -> audit.info("History of {} for identity '{}' successful: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("History of {} for identity '{}' failed: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
    }

    @Override
    public Response update(String id, R resource, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional dbResource = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, this.resourceTypeName, () -> this.dao.read(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        if (dbResource.isEmpty()) {
            audit.info("Create as update of non existing {} denied for identity '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.responseGenerator.updateAsCreateNotAllowed(this.resourceTypeName);
        }
        Resource cleanedDbResource = this.referenceCleaner.cleanLiteralReferences((Resource)dbResource.get());
        return this.update(id, resource, uri, headers, cleanedDbResource);
    }

    private Response update(String id, R newResource, UriInfo uri, HttpHeaders headers, R oldResource) {
        this.resolveLiteralInternalRelatedArtifactOrAttachmentUrls(newResource);
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        Optional<String> reasonUpdateAllowed = this.authorizationRule.reasonUpdateAllowed(this.getCurrentIdentity(), oldResource, newResource);
        if (reasonUpdateAllowed.isEmpty()) {
            audit.info("Update of {}/{}/_history/{} denied for identity '{}'", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName()});
            return this.forbidden("update");
        }
        return this.withResourceValidation(newResource, uri, headers, "Update", () -> {
            audit.info("Update of {}/{}/_history/{} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), reasonUpdateAllowed.get()});
            Response updated = this.logResultStatus(() -> ((BasicResourceService)this.delegate).update(id, newResource, uri, headers), status -> audit.info("Update of {}/{}/_history/{} for identity '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("Update of {}/{}/_history/{} for identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
            if (updated.hasEntity() && !this.resourceType.isInstance(updated.getEntity()) && !(updated.getEntity() instanceof OperationOutcome)) {
                logger.warn("Update returned with entity of type {}", (Object)updated.getEntity().getClass().getName());
            } else if (!updated.hasEntity() && !PreferReturnType.MINIMAL.equals((Object)this.parameterConverter.getPreferReturn(headers))) {
                logger.warn("Update returned with status {}, but no entity", (Object)updated.getStatus());
            }
            return updated;
        });
    }

    @Override
    public Response update(R resource, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        MultivaluedMap queryParameters = uri.getQueryParameters();
        PartialResult<R> result = this.getExisting((Map<String, List<String>>)queryParameters);
        if (result.getTotal() <= 0 && !resource.hasId()) {
            return this.create(resource, uri, headers);
        }
        if (result.getTotal() <= 0 && resource.hasId()) {
            audit.info("Create as update of non existing {} denied for identity '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.responseGenerator.updateAsCreateNotAllowed(this.resourceTypeName);
        }
        if (result.getTotal() == 1) {
            Resource dbResource = (Resource)result.getPartialResult().get(0);
            IdType dbResourceId = dbResource.getIdElement();
            if (!resource.hasId()) {
                resource.setIdElement(dbResourceId);
                return this.update(resource.getIdElement().getIdPart(), resource, uri, headers, resource);
            }
            if (resource.hasId() && (!resource.getIdElement().hasBaseUrl() || this.serverBase.equals(resource.getIdElement().getBaseUrl())) && (!resource.getIdElement().hasResourceType() || this.resourceTypeName.equals(resource.getIdElement().getResourceType())) && dbResourceId.getIdPart().equals(resource.getIdElement().getIdPart())) {
                return this.update(resource.getIdElement().getIdPart(), resource, uri, headers, resource);
            }
            audit.info("Update of {}/{}/_history/{} denied for identity '{}', new resource has different id", new Object[]{this.resourceTypeName, dbResourceId.getValue(), dbResourceId.getVersionIdPart(), this.getCurrentIdentity().getName()});
            return this.responseGenerator.badRequestIdsNotMatching(dbResourceId.withServerBase(this.serverBase, this.resourceTypeName), resource.getIdElement().hasBaseUrl() && resource.getIdElement().hasResourceType() ? resource.getIdElement() : resource.getIdElement().withServerBase(this.serverBase, this.resourceTypeName));
        }
        audit.info("Update of {} denied for identity '{}', conditional update criteria not selective enough, multiple matches", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
        return this.responseGenerator.multipleExists(this.resourceTypeName, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap((Map)queryParameters)).toUriString());
    }

    private PartialResult<R> getExisting(Map<String, List<String>> queryParameters) {
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("Query contains parameter not applicable in this conditional update context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery query = this.dao.createSearchQueryWithoutUserFilter(1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            audit.info("Update of resource {} denied for identity '{}', conditional update criteria contains unsupported parameters", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            throw new WebApplicationException(this.responseGenerator.badRequest(UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap(queryParameters)).toUriString(), unsupportedQueryParameters));
        }
        return this.exceptionHandler.handleSqlException(() -> this.dao.search(query));
    }

    @Override
    public Response delete(String id, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional dbResource = this.exceptionHandler.handleSqlException(() -> this.dao.readIncludingDeleted(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        if (dbResource.isPresent()) {
            Resource oldResource = (Resource)dbResource.get();
            String resourceId = oldResource.getIdElement().getIdPart();
            long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
            Optional<String> reasonDeleteAllowed = this.authorizationRule.reasonDeleteAllowed(this.getCurrentIdentity(), oldResource);
            if (reasonDeleteAllowed.isEmpty()) {
                audit.info("Delete of {}/{}/_history/{} denied for identity '{}'", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName()});
                return this.forbidden("delete");
            }
            audit.info("Delete of {}/{}/_history/{} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), reasonDeleteAllowed.get()});
            return this.logResultStatus(() -> ((BasicResourceService)this.delegate).delete(id, uri, headers), status -> audit.info("Delete of {}/{}/_history/{} for identity '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("Delete of {}/{}/_history/{} for identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
        }
        audit.info("{} to delete not found for user '{}'", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), this.getCurrentIdentity().getName()});
        return this.responseGenerator.notFound(id, this.resourceTypeName);
    }

    @Override
    public Response delete(UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Object queryParameters = uri.getQueryParameters();
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(((Map)queryParameters)::containsKey)) {
            logger.warn("Query contains parameter not applicable in this conditional delete context: '{}', parameters {} will be ignored", (Object)UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap((Map)queryParameters)).toUriString(), (Object)Arrays.toString(SearchQuery.STANDARD_PARAMETERS));
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery query = this.dao.createSearchQuery(this.getCurrentIdentity(), 1, 1);
        query.configureParameters((Map<String, List<String>>)queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            audit.info("Delete of {} denied for identity '{}', conditional delete criteria contains unsupported parameters", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.responseGenerator.badRequest(UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap((Map)queryParameters)).toUriString(), unsupportedQueryParameters);
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> this.dao.search(query));
        if (result.getTotal() <= 0) {
            audit.info("No {} resource deleted for identity '{}', conditional delete criteria produced no matches", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return Response.noContent().build();
        }
        if (result.getTotal() == 1) {
            Resource resource = (Resource)result.getPartialResult().get(0);
            return this.delete(resource.getIdElement().getIdPart(), uri, headers);
        }
        audit.info("Delete of {} denied for identity '{}', conditional delete criteria not selective enough, multiple matches", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
        return this.responseGenerator.multipleExists(this.resourceTypeName, UriComponentsBuilder.newInstance().replaceQueryParams(CollectionUtils.toMultiValueMap((Map)queryParameters)).toUriString());
    }

    @Override
    public Response search(UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional<String> reasonSearchAllowed = this.authorizationRule.reasonSearchAllowed(this.getCurrentIdentity());
        if (reasonSearchAllowed.isEmpty()) {
            audit.info("Search of {} denied for identity '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
            return this.forbidden("search");
        }
        audit.info("Search of {} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), reasonSearchAllowed.get()});
        return this.logResultStatus(() -> ((BasicResourceService)this.delegate).search(uri, headers), status -> audit.info("Search of {} for identity '{} successful, status: {} {}'", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("Search of {} for identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
    }

    @Override
    public Response postValidateNew(String validate, Parameters parameters, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        return ((BasicResourceService)this.delegate).postValidateNew(validate, parameters, uri, headers);
    }

    @Override
    public Response getValidateNew(String validate, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        return ((BasicResourceService)this.delegate).getValidateNew(validate, uri, headers);
    }

    @Override
    public Response postValidateExisting(String validate, String id, Parameters parameters, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        return ((BasicResourceService)this.delegate).postValidateExisting(validate, id, parameters, uri, headers);
    }

    @Override
    public Response getValidateExisting(String validate, String id, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        return ((BasicResourceService)this.delegate).getValidateExisting(validate, id, uri, headers);
    }

    @Override
    public Response deletePermanently(String deletePath, String id, UriInfo uri, HttpHeaders headers) {
        this.logCurrentIdentity();
        Optional dbResource = this.exceptionHandler.handleSqlException(() -> this.dao.readIncludingDeleted(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        if (dbResource.isPresent()) {
            Resource oldResource = (Resource)dbResource.get();
            String resourceId = oldResource.getIdElement().getIdPart();
            long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
            Optional<String> reasonDeleteAllowed = this.authorizationRule.reasonPermanentDeleteAllowed(this.getCurrentIdentity(), oldResource);
            if (reasonDeleteAllowed.isEmpty()) {
                audit.info("Permanent delete of {}/{}/_history/{} denied for identity '{}'", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName()});
                return this.forbidden("delete");
            }
            audit.info("Permanent delete of {}/{}/_history/{} allowed for identity '{}', reason: {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), reasonDeleteAllowed.get()});
            return this.logResultStatus(() -> ((BasicResourceService)this.delegate).deletePermanently(deletePath, id, uri, headers), status -> audit.info("Permanent delete of {}/{}/_history/{} by identity '{}' successful, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}), status -> audit.info("Permanent delete of {}/{}/_history/{} by identity '{}' failed, status: {} {}", new Object[]{this.resourceTypeName, resourceId, resourceVersion, this.getCurrentIdentity().getName(), status.getStatusCode(), status.getReasonPhrase()}));
        }
        audit.info("{} to permanently delete not found for user '{}'", (Object)this.resourceTypeName, (Object)this.getCurrentIdentity().getName());
        return this.responseGenerator.notFound(id, this.resourceTypeName);
    }

    private Response logResultStatus(Supplier<Response> responseSupplier, Consumer<Response.StatusType> logSuccessForStatusCode, Consumer<Response.StatusType> logErrorForStatusCode) {
        try {
            Response response = responseSupplier.get();
            if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                logSuccessForStatusCode.accept(response.getStatusInfo());
            } else {
                logErrorForStatusCode.accept(response.getStatusInfo());
            }
            return response;
        }
        catch (Exception e) {
            Response.Status status = e instanceof WebApplicationException && ((WebApplicationException)((Object)e)).getResponse() != null ? ((WebApplicationException)((Object)e)).getResponse().getStatusInfo() : Response.Status.INTERNAL_SERVER_ERROR;
            logErrorForStatusCode.accept((Response.StatusType)status);
            throw e;
        }
    }
}

