/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.impl;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.help.SummaryMode;
import dev.dsf.fhir.history.HistoryService;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import dev.dsf.fhir.validation.ResourceValidator;
import dev.dsf.fhir.webservice.base.AbstractBasicService;
import dev.dsf.fhir.webservice.specification.BasicResourceService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractResourceServiceImpl<D extends ResourceDao<R>, R extends Resource>
extends AbstractBasicService
implements BasicResourceService<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceServiceImpl.class);
    private final String path;
    protected final Class<R> resourceType;
    protected final String resourceTypeName;
    protected final String serverBase;
    protected final int defaultPageCount;
    protected final D dao;
    protected final ResourceValidator validator;
    protected final EventHandler eventHandler;
    protected final ExceptionHandler exceptionHandler;
    protected final EventGenerator eventGenerator;
    protected final ResponseGenerator responseGenerator;
    protected final ParameterConverter parameterConverter;
    protected final ReferenceExtractor referenceExtractor;
    protected final ReferenceResolver referenceResolver;
    protected final ReferenceCleaner referenceCleaner;
    protected final AuthorizationRuleProvider authorizationRuleProvider;
    protected final HistoryService historyService;

    public AbstractResourceServiceImpl(String path, Class<R> resourceType, String serverBase, int defaultPageCount, D dao, ResourceValidator validator, EventHandler eventHandler, ExceptionHandler exceptionHandler, EventGenerator eventGenerator, ResponseGenerator responseGenerator, ParameterConverter parameterConverter, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, AuthorizationRuleProvider authorizationRuleProvider, HistoryService historyService) {
        this.path = path;
        this.resourceType = resourceType;
        this.resourceTypeName = resourceType.getAnnotation(ResourceDef.class).name();
        this.serverBase = serverBase;
        this.defaultPageCount = defaultPageCount;
        this.dao = dao;
        this.validator = validator;
        this.eventHandler = eventHandler;
        this.exceptionHandler = exceptionHandler;
        this.eventGenerator = eventGenerator;
        this.responseGenerator = responseGenerator;
        this.parameterConverter = parameterConverter;
        this.referenceExtractor = referenceExtractor;
        this.referenceResolver = referenceResolver;
        this.referenceCleaner = referenceCleaner;
        this.authorizationRuleProvider = authorizationRuleProvider;
        this.historyService = historyService;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.path, "path");
        Objects.requireNonNull(this.resourceType, "resourceType");
        Objects.requireNonNull(this.resourceTypeName, "resourceTypeName");
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(Integer.valueOf(this.defaultPageCount), "defaultPageCount");
        Objects.requireNonNull(this.dao, "dao");
        Objects.requireNonNull(this.validator, "validator");
        Objects.requireNonNull(this.eventHandler, "eventHandler");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
        Objects.requireNonNull(this.eventGenerator, "eventGenerator");
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
        Objects.requireNonNull(this.referenceExtractor, "referenceExtractor");
        Objects.requireNonNull(this.referenceResolver, "referenceResolver");
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.authorizationRuleProvider, "authorizationRuleProvider");
        Objects.requireNonNull(this.historyService, "historyService");
    }

    @Override
    public Response create(R resource, UriInfo uri, HttpHeaders headers) {
        this.checkAlreadyExists(headers);
        Consumer<R> afterCreate = this.preCreate(resource);
        Resource createdResource = this.exceptionHandler.handleSqlException(() -> {
            Connection connection = this.dao.newReadWriteTransaction();
            try {
                this.resolveLogicalReferences((Resource)resource, connection);
                Resource created = this.dao.createWithTransactionAndId(connection, (Resource)resource, UUID.randomUUID());
                this.checkReferences((Resource)resource, connection, ref -> this.checkReferenceAfterCreate(resource, (ResourceReference)ref));
                connection.commit();
                Resource resource2 = created;
                return resource2;
            }
            catch (WebApplicationException | SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        });
        this.referenceCleaner.cleanLiteralReferences(createdResource);
        this.eventHandler.handleEvent(this.eventGenerator.newResourceCreatedEvent(createdResource));
        if (afterCreate != null) {
            afterCreate.accept(createdResource);
        }
        URI location = this.toLocation(createdResource);
        return this.responseGenerator.response(Response.Status.CREATED, createdResource, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers), this.parameterConverter.getPreferReturn(headers), () -> this.responseGenerator.created(location, createdResource)).location(location).build();
    }

    protected boolean checkReferenceAfterCreate(R created, ResourceReference ref) {
        return true;
    }

    private URI toLocation(R resource) {
        return UriBuilder.fromUri((String)this.serverBase).path(resource.getResourceType().name()).path("/{id}/_history/{vid}").build(new Object[]{resource.getIdElement().getIdPart(), resource.getIdElement().getVersionIdPart()});
    }

    private void resolveLogicalReferences(Resource resource, Connection connection) throws WebApplicationException {
        this.referenceExtractor.getReferences(resource).filter(ref -> ResourceReference.ReferenceType.LOGICAL.equals((Object)ref.getType(this.serverBase))).filter(ref -> this.referenceResolver.referenceCanBeResolved((ResourceReference)ref, connection)).forEach(ref -> {
            Optional<OperationOutcome> outcome = this.resolveLogicalReference(resource, (ResourceReference)ref, connection);
            if (outcome.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome.get()).build();
                throw new WebApplicationException(response);
            }
        });
    }

    private Optional<OperationOutcome> resolveLogicalReference(Resource resource, ResourceReference reference, Connection connection) {
        Optional<Resource> resolvedResource = this.referenceResolver.resolveReference(this.getCurrentIdentity(), reference, connection);
        if (resolvedResource.isPresent()) {
            Resource target = resolvedResource.get();
            reference.getReference().setReferenceElement((IIdType)new IdType(target.getResourceType().name(), target.getIdElement().getIdPart()));
            return Optional.empty();
        }
        return Optional.of(this.responseGenerator.referenceTargetNotFoundLocallyByIdentifier(resource, reference));
    }

    private void checkReferences(Resource resource, Connection connection, Predicate<ResourceReference> checkReference) throws WebApplicationException {
        this.referenceExtractor.getReferences(resource).filter(checkReference).filter(ref -> this.referenceResolver.referenceCanBeChecked((ResourceReference)ref, connection)).forEach(ref -> {
            Optional<OperationOutcome> outcome = this.checkReference(resource, connection, (ResourceReference)ref);
            if (outcome.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome.get()).build();
                throw new WebApplicationException(response);
            }
        });
    }

    private Optional<OperationOutcome> checkReference(Resource resource, Connection connection, ResourceReference reference) throws WebApplicationException {
        ResourceReference.ReferenceType type = reference.getType(this.serverBase);
        switch (type) {
            case LITERAL_INTERNAL: 
            case RELATED_ARTEFACT_LITERAL_INTERNAL_URL: 
            case ATTACHMENT_LITERAL_INTERNAL_URL: {
                return this.referenceResolver.checkLiteralInternalReference(resource, reference, connection);
            }
            case LITERAL_EXTERNAL: 
            case RELATED_ARTEFACT_LITERAL_EXTERNAL_URL: 
            case ATTACHMENT_LITERAL_EXTERNAL_URL: {
                return this.referenceResolver.checkLiteralExternalReference(resource, reference);
            }
            case LOGICAL: {
                return this.referenceResolver.checkLogicalReference(this.getCurrentIdentity(), resource, reference, connection);
            }
            case RELATED_ARTEFACT_UNKNOWN_URL: 
            case ATTACHMENT_UNKNOWN_URL: {
                return Optional.empty();
            }
        }
        return Optional.of(this.responseGenerator.unknownReference(resource, reference));
    }

    private void checkAlreadyExists(HttpHeaders headers) throws WebApplicationException {
        UriComponents componentes;
        String path;
        Optional<String> ifNoneExistHeader = this.getHeaderString(headers, "If-None-Exist", Constants.HEADER_IF_NONE_EXIST_LC);
        if (ifNoneExistHeader.isEmpty()) {
            return;
        }
        if (ifNoneExistHeader.get().isBlank()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue(ifNoneExistHeader.get()));
        }
        Object ifNoneExistHeaderValue = ifNoneExistHeader.get();
        if (!((String)ifNoneExistHeaderValue).contains("?")) {
            ifNoneExistHeaderValue = "?" + (String)ifNoneExistHeaderValue;
        }
        if ((path = (componentes = UriComponentsBuilder.fromUriString((String)ifNoneExistHeaderValue).build()).getPath()) != null && !path.isBlank()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue(ifNoneExistHeader.get()));
        }
        Map<String, List<String>> queryParameters = this.parameterConverter.urlDecodeQueryParameters((Map<String, List<String>>)componentes.getQueryParams());
        if (Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(queryParameters::containsKey)) {
            logger.warn("{} Header contains query parameter not applicable in this conditional create context: '{}', parameters {} will be ignored", new Object[]{"If-None-Exist", ifNoneExistHeader.get(), Arrays.toString(SearchQuery.STANDARD_PARAMETERS)});
            queryParameters = queryParameters.entrySet().stream().filter(e -> !Arrays.stream(SearchQuery.STANDARD_PARAMETERS).anyMatch(p -> p.equals(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SearchQuery query = this.dao.createSearchQueryWithoutUserFilter(1, 1);
        query.configureParameters(queryParameters);
        List<SearchQueryParameterError> unsupportedQueryParameters = query.getUnsupportedQueryParameters();
        if (!unsupportedQueryParameters.isEmpty()) {
            throw new WebApplicationException(this.responseGenerator.badIfNoneExistHeaderValue(ifNoneExistHeader.get(), unsupportedQueryParameters));
        }
        PartialResult result = this.exceptionHandler.handleSqlException(() -> this.dao.search(query));
        if (result.getTotal() == 1) {
            throw new WebApplicationException(this.responseGenerator.oneExists((Resource)result.getPartialResult().get(0), ifNoneExistHeader.get()));
        }
        if (result.getTotal() > 1) {
            throw new WebApplicationException(this.responseGenerator.multipleExists(this.resourceTypeName, ifNoneExistHeader.get()));
        }
    }

    private Optional<String> getHeaderString(HttpHeaders headers, String ... headerNames) {
        return Arrays.stream(headerNames).map(name -> headers.getHeaderString(name)).filter(h -> h != null).findFirst();
    }

    protected Consumer<R> preCreate(R resource) throws WebApplicationException {
        return null;
    }

    @Override
    public Response read(String id, UriInfo uri, HttpHeaders headers) {
        Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, this.resourceTypeName, () -> this.dao.read(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        Optional ifNoneMatch = this.getHeaderString(headers, "If-None-Match", Constants.HEADER_IF_NONE_MATCH_LC).flatMap(this.parameterConverter::toEntityTag);
        Optional ifModifiedSince = this.getHeaderString(headers, "If-Modified-Since", Constants.HEADER_IF_MODIFIED_SINCE_LC).flatMap(this::toDate);
        return read.map(resource -> {
            this.referenceCleaner.cleanLiteralReferences(resource);
            EntityTag resourceTag = new EntityTag(resource.getMeta().getVersionId(), true);
            if (ifNoneMatch.map(t -> t.equals((Object)resourceTag)).orElse(false).booleanValue()) {
                return Response.notModified((EntityTag)resourceTag).entity(resource).lastModified(resource.getMeta().getLastUpdated()).build();
            }
            if (ifNoneMatch.isEmpty() && ifModifiedSince.map(d -> !this.afterWithSecondsPrecision(resource.getMeta().getLastUpdated(), (Date)d)).orElse(false).booleanValue()) {
                return Response.notModified((EntityTag)resourceTag).entity(resource).lastModified(resource.getMeta().getLastUpdated()).build();
            }
            return this.responseGenerator.response(Response.Status.OK, (Resource)resource, this.getMediaTypeForRead(uri, headers)).build();
        }).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private boolean afterWithSecondsPrecision(Date a, Date b) {
        LocalDateTime aLdt = a.toInstant().atZone(ZoneOffset.UTC.normalized()).toLocalDateTime().truncatedTo(ChronoUnit.SECONDS);
        LocalDateTime bLdt = b.toInstant().atZone(ZoneOffset.UTC.normalized()).toLocalDateTime().truncatedTo(ChronoUnit.SECONDS);
        return aLdt.isAfter(bLdt);
    }

    protected MediaType getMediaTypeForRead(UriInfo uri, HttpHeaders headers) {
        return this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers);
    }

    private Optional<Date> toDate(String rfc1123DateValue) {
        if (rfc1123DateValue == null || rfc1123DateValue.isBlank()) {
            return Optional.empty();
        }
        try {
            ZonedDateTime parsed = ZonedDateTime.parse(rfc1123DateValue, DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault()));
            return Optional.of(Date.from(parsed.toInstant()));
        }
        catch (DateTimeParseException e) {
            logger.warn("Not a RFC-1123 date", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Response vread(String id, long version, UriInfo uri, HttpHeaders headers) {
        Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, id, () -> this.dao.readVersion(this.parameterConverter.toUuid(this.resourceTypeName, id), version));
        Optional ifNoneMatch = this.getHeaderString(headers, "If-None-Match", Constants.HEADER_IF_NONE_MATCH_LC).flatMap(this.parameterConverter::toEntityTag);
        Optional ifModifiedSince = this.getHeaderString(headers, "If-Modified-Since", Constants.HEADER_IF_MODIFIED_SINCE_LC).flatMap(this::toDate);
        return read.map(resource -> {
            this.referenceCleaner.cleanLiteralReferences(resource);
            EntityTag resourceTag = new EntityTag(resource.getMeta().getVersionId(), true);
            if (ifNoneMatch.map(t -> t.equals((Object)resourceTag)).orElse(false).booleanValue()) {
                return Response.notModified((EntityTag)resourceTag).entity(resource).lastModified(resource.getMeta().getLastUpdated()).build();
            }
            if (ifNoneMatch.isEmpty() && ifModifiedSince.map(d -> !this.afterWithSecondsPrecision(resource.getMeta().getLastUpdated(), (Date)d)).orElse(false).booleanValue()) {
                return Response.notModified((EntityTag)resourceTag).entity(resource).lastModified(resource.getMeta().getLastUpdated()).build();
            }
            return this.responseGenerator.response(Response.Status.OK, (Resource)resource, this.getMediaTypeForVRead(uri, headers)).build();
        }).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    protected MediaType getMediaTypeForVRead(UriInfo uri, HttpHeaders headers) {
        return this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers);
    }

    @Override
    public Response history(UriInfo uri, HttpHeaders headers) {
        Bundle history = this.historyService.getHistory(this.getCurrentIdentity(), uri, headers, this.resourceType);
        return this.responseGenerator.response(Response.Status.OK, this.referenceCleaner.cleanLiteralReferences((Resource)history), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    @Override
    public Response history(String id, UriInfo uri, HttpHeaders headers) {
        Bundle history = this.historyService.getHistory(this.getCurrentIdentity(), uri, headers, this.resourceType, id);
        return this.responseGenerator.response(Response.Status.OK, (Resource)history, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    @Override
    public Response update(String id, R resource, UriInfo uri, HttpHeaders headers) {
        IdType resourceId = resource.getIdElement();
        if (!Objects.equals(id, resourceId.getIdPart())) {
            return this.responseGenerator.pathVsElementId(this.resourceTypeName, id, resourceId);
        }
        if (resourceId.getBaseUrl() != null && !this.serverBase.equals(resourceId.getBaseUrl())) {
            return this.responseGenerator.invalidBaseUrl(this.resourceTypeName, resourceId);
        }
        Consumer<R> afterUpdate = this.preUpdate(resource);
        Optional ifMatch = this.getHeaderString(headers, "If-Match", Constants.HEADER_IF_MATCH_LC).flatMap(this.parameterConverter::toEntityTag).flatMap(this.parameterConverter::toVersion);
        Resource updatedResource = this.exceptionHandler.handleSqlExAndResourceNotFoundExAndResouceVersionNonMatchEx(this.resourceTypeName, () -> {
            Connection connection = this.dao.newReadWriteTransaction();
            try {
                this.resolveLogicalReferences((Resource)resource, connection);
                Resource updated = this.dao.update((Resource)resource, ifMatch.orElse(null));
                this.checkReferences((Resource)resource, connection, ref -> this.checkReferenceAfterUpdate((R)updated, (ResourceReference)ref));
                connection.commit();
                Resource resource2 = updated;
                return resource2;
            }
            catch (WebApplicationException | SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        });
        this.referenceCleaner.cleanLiteralReferences(updatedResource);
        this.eventHandler.handleEvent(this.eventGenerator.newResourceUpdatedEvent(updatedResource));
        if (afterUpdate != null) {
            afterUpdate.accept(updatedResource);
        }
        URI location = this.toLocation(updatedResource);
        return this.responseGenerator.response(Response.Status.OK, updatedResource, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers), this.parameterConverter.getPreferReturn(headers), () -> this.responseGenerator.updated(location, updatedResource)).location(location).build();
    }

    protected boolean checkReferenceAfterUpdate(R updated, ResourceReference ref) {
        return true;
    }

    protected Consumer<R> preUpdate(R resource) {
        return null;
    }

    @Override
    public Response update(R resource, UriInfo uri, HttpHeaders headers) {
        throw new UnsupportedOperationException("Implemented and delegated by security layer");
    }

    @Override
    public Response delete(String id, UriInfo uri, HttpHeaders headers) {
        Consumer<String> afterDelete = this.preDelete(id);
        boolean deleted = this.exceptionHandler.handleSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.dao.delete(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        if (deleted) {
            this.eventHandler.handleEvent(this.eventGenerator.newResourceDeletedEvent(this.resourceType, id));
        }
        if (afterDelete != null) {
            afterDelete.accept(id);
        }
        return this.responseGenerator.response(Response.Status.OK, (Resource)this.responseGenerator.resourceDeleted(this.resourceTypeName, id), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    protected Consumer<String> preDelete(String id) {
        return null;
    }

    @Override
    public Response delete(UriInfo uri, HttpHeaders headers) {
        throw new UnsupportedOperationException("Implemented and delegated by security layer");
    }

    @Override
    public Response search(UriInfo uri, HttpHeaders headers) {
        MultivaluedMap queryParameters = uri.getQueryParameters();
        Integer page = this.parameterConverter.getFirstInt((Map<String, List<String>>)queryParameters, "_page");
        int effectivePage = page == null ? 1 : page;
        Integer count = this.parameterConverter.getFirstInt((Map<String, List<String>>)queryParameters, "_count");
        int effectiveCount = count == null || count < 0 ? this.defaultPageCount : count;
        SearchQuery query = this.dao.createSearchQuery(this.getCurrentIdentity(), effectivePage, effectiveCount);
        query.configureParameters((Map<String, List<String>>)queryParameters);
        List<SearchQueryParameterError> errors = query.getUnsupportedQueryParameters();
        if (!errors.isEmpty() && PreferHandlingType.STRICT.equals((Object)this.parameterConverter.getPreferHandling(headers))) {
            return this.responseGenerator.response(Response.Status.BAD_REQUEST, (Resource)this.responseGenerator.toOperationOutcomeError(errors), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
        }
        PartialResult<R> result = this.exceptionHandler.handleSqlException(() -> this.dao.search(query));
        result = this.filterIncludeResources(result);
        UriBuilder bundleUri = query.configureBundleUri(UriBuilder.fromPath((String)this.serverBase).path(this.path));
        String format = (String)queryParameters.getFirst((Object)"_format");
        String pretty = (String)queryParameters.getFirst((Object)"_pretty");
        SummaryMode summary = SummaryMode.fromString((String)queryParameters.getFirst((Object)"_summary"));
        Bundle searchSet = this.responseGenerator.createSearchSet(result, errors, bundleUri, format, pretty, summary);
        searchSet.getEntry().stream().filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).forEach(arg_0 -> ((ReferenceCleaner)this.referenceCleaner).cleanLiteralReferences(arg_0));
        return this.responseGenerator.response(Response.Status.OK, (Resource)searchSet, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    private PartialResult<R> filterIncludeResources(PartialResult<R> result) {
        List<Resource> includes = this.filterIncludeResources(result.getIncludes());
        return new PartialResult<R>(result.getTotal(), result.getPageAndCount(), result.getPartialResult(), includes);
    }

    private List<Resource> filterIncludeResources(List<Resource> includes) {
        return includes.stream().filter(this::filterIncludeResource).collect(Collectors.toList());
    }

    private boolean filterIncludeResource(Resource include) {
        Optional<AuthorizationRule<?>> optRule = this.authorizationRuleProvider.getAuthorizationRule(include.getClass());
        return optRule.map(rule -> rule).flatMap(rule -> rule.reasonReadAllowed(this.getCurrentIdentity(), include)).map(reason -> {
            logger.debug("Include resource of type {} with id {}, allowed - {}", new Object[]{include.getClass().getAnnotation(ResourceDef.class).name(), include.getIdElement().getValue(), reason});
            return true;
        }).orElseGet(() -> {
            logger.debug("Include resource of type {} with id {}, filtered (read not allowed)", (Object)include.getClass().getAnnotation(ResourceDef.class).name(), (Object)include.getIdElement().getValue());
            return false;
        });
    }

    private Optional<Resource> getResource(Parameters parameters, String parameterName) {
        return parameters.getParameter().stream().filter(p -> parameterName.equals(p.getName())).findFirst().map(Parameters.ParametersParameterComponent::getResource);
    }

    private OperationOutcome createValidationOutcomeError(List<SingleValidationMessage> messages) {
        OperationOutcome outcome = new OperationOutcome();
        List issues = messages.stream().map(vm -> new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(this.toSeverity(vm.getSeverity())).setCode(OperationOutcome.IssueType.STRUCTURE).setDiagnostics(vm.getMessage())).collect(Collectors.toList());
        outcome.setIssue(issues);
        return outcome;
    }

    private OperationOutcome.IssueSeverity toSeverity(ResultSeverityEnum resultSeverity) {
        switch (resultSeverity) {
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private OperationOutcome createValidationOutcomeOk(List<SingleValidationMessage> messages, List<String> profiles) {
        OperationOutcome outcome = new OperationOutcome();
        List issues = messages.stream().map(vm -> new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(this.toSeverity(vm.getSeverity())).setCode(OperationOutcome.IssueType.STRUCTURE).setDiagnostics(vm.getMessage())).collect(Collectors.toList());
        outcome.setIssue(issues);
        OperationOutcome.OperationOutcomeIssueComponent ok = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.INFORMATION).setCode(OperationOutcome.IssueType.INFORMATIONAL).setDiagnostics("Resource validated" + (String)(profiles.isEmpty() ? "" : " with profile" + (profiles.size() > 1 ? "s " : " ") + profiles.stream().collect(Collectors.joining(", "))));
        outcome.addIssue(ok);
        return outcome;
    }

    @Override
    public Response postValidateNew(String validate, Parameters parameters, UriInfo uri, HttpHeaders headers) {
        Optional<Resource> resource = this.getResource(parameters, "resource");
        if (resource.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Type mode = parameters.getParameter("mode");
        if (!(mode instanceof CodeType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Type profile = parameters.getParameter("profile");
        if (!(profile instanceof UriType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }

    @Override
    public Response getValidateNew(String validate, UriInfo uri, HttpHeaders headers) {
        return Response.ok().build();
    }

    @Override
    public Response postValidateExisting(String validate, String id, Parameters parameters, UriInfo uri, HttpHeaders headers) {
        if (this.getResource(parameters, "resource").isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Type mode = parameters.getParameter("mode");
        if (!(mode instanceof CodeType) || !(mode instanceof StringType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!"profile".equals(((StringType)mode).getValue())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Type profile = parameters.getParameter("profile");
        if (!(profile instanceof UriType && mode instanceof UrlType && mode instanceof CanonicalType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        UriType profileUri = (UriType)profile;
        Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, this.resourceTypeName, () -> this.dao.read(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        Resource resource = (Resource)read.get();
        resource.getMeta().setProfile(Collections.singletonList(new CanonicalType((String)profileUri.getValue())));
        ValidationResult result = this.validator.validate(resource);
        if (result.isSuccessful()) {
            return this.responseGenerator.response(Response.Status.OK, (Resource)this.createValidationOutcomeOk(result.getMessages(), Collections.singletonList((String)profileUri.getValue())), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
        }
        return this.responseGenerator.response(Response.Status.OK, (Resource)this.createValidationOutcomeError(result.getMessages()), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }

    @Override
    public Response getValidateExisting(String validate, String id, UriInfo uri, HttpHeaders headers) {
        MultivaluedMap queryParameters = uri.getQueryParameters();
        String mode = (String)queryParameters.getFirst((Object)"mode");
        if (mode == null) {
            mode = "profile";
        }
        String profile = (String)queryParameters.getFirst((Object)"profile");
        if ("profile".equals(mode)) {
            ValidationResult result;
            Optional read = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, this.resourceTypeName, () -> this.dao.read(this.parameterConverter.toUuid(this.resourceTypeName, id)));
            Resource resource = (Resource)read.get();
            if (profile != null) {
                resource.getMeta().setProfile(Collections.singletonList(new CanonicalType(profile)));
            }
            if ((result = this.validator.validate(resource)).isSuccessful()) {
                return this.responseGenerator.response(Response.Status.OK, (Resource)this.createValidationOutcomeOk(result.getMessages(), resource.getMeta().getProfile().stream().map(t -> (String)t.getValue()).collect(Collectors.toList())), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
            }
            return this.responseGenerator.response(Response.Status.OK, (Resource)this.createValidationOutcomeError(result.getMessages()), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
        }
        if ("delete".equals(mode)) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
    }

    @Override
    public Response deletePermanently(String deletePath, String id, UriInfo uri, HttpHeaders headers) {
        this.exceptionHandler.handleSqlResourceNotFoundAndResourceNotMarkedDeletedException(this.resourceTypeName, () -> this.dao.deletePermanently(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        return this.responseGenerator.response(Response.Status.OK, (Resource)this.responseGenerator.resourceDeletedPermanently(this.resourceTypeName, id), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
    }
}

