/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.subscription;

import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.search.Matcher;
import dev.dsf.fhir.search.SearchQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class MatcherFactory {
    private final Map<String, ResourceDao<? extends Resource>> daosByResourceName = new HashMap<String, ResourceDao<? extends Resource>>();

    public MatcherFactory(Map<String, ResourceDao<? extends Resource>> daosByResourceName) {
        if (daosByResourceName != null) {
            this.daosByResourceName.putAll(daosByResourceName);
        }
    }

    public Optional<Matcher> createMatcher(String uri) {
        UriComponents componentes = UriComponentsBuilder.fromUriString((String)uri).build();
        String path = componentes.getPath();
        MultiValueMap queryParameters = componentes.getQueryParams();
        if (this.daosByResourceName.containsKey(path)) {
            ResourceDao<? extends Resource> dao = this.daosByResourceName.get(path);
            SearchQuery<? extends Resource> query = dao.createSearchQueryWithoutUserFilter(1, 1);
            query.configureParameters((Map<String, List<String>>)queryParameters);
            return Optional.of(query);
        }
        return Optional.empty();
    }
}

