/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.dao.command.ValidationHelperImpl;
import dev.dsf.fhir.service.ValidationSupportWithCache;
import dev.dsf.fhir.service.ValidationSupportWithFetchFromDb;
import dev.dsf.fhir.service.ValidationSupportWithFetchFromDbWithTransaction;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.validation.ResourceValidator;
import dev.dsf.fhir.validation.ResourceValidatorImpl;
import java.sql.Connection;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ValidationConfig {
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private HelperConfig helperConfig;

    @Bean
    public IValidationSupport validationSupport() {
        return new ValidationSupportWithCache(this.fhirConfig.fhirContext(), (IValidationSupport)this.validationSupportChain(new ValidationSupportWithFetchFromDb(this.fhirConfig.fhirContext(), this.daoConfig.structureDefinitionDao(), this.daoConfig.structureDefinitionSnapshotDao(), this.daoConfig.codeSystemDao(), this.daoConfig.valueSetDao(), this.daoConfig.measureDao())));
    }

    private ValidationSupportChain validationSupportChain(IValidationSupport dbSupport) {
        DefaultProfileValidationSupport dpvs = new DefaultProfileValidationSupport(FhirContext.forR4());
        dpvs.fetchCodeSystem("");
        dpvs.fetchAllStructureDefinitions();
        return new ValidationSupportChain(new IValidationSupport[]{new InMemoryTerminologyServerValidationSupport(this.fhirConfig.fhirContext()), dbSupport, dpvs, new CommonCodeSystemsTerminologyService(this.fhirConfig.fhirContext())});
    }

    @Bean
    public ResourceValidator resourceValidator() {
        return new ResourceValidatorImpl(this.fhirConfig.fhirContext(), this.validationSupport());
    }

    @Bean
    public ValidationHelper validationHelper() {
        return new ValidationHelperImpl(this.resourceValidator(), this.helperConfig.responseGenerator());
    }

    @Bean
    @Scope(value="prototype")
    public IValidationSupport validationSupportWithTransaction(Connection connection) {
        ValidationSupportWithCache validationSupport = new ValidationSupportWithCache(this.fhirConfig.fhirContext(), (IValidationSupport)this.validationSupportChain(new ValidationSupportWithFetchFromDbWithTransaction(this.fhirConfig.fhirContext(), this.daoConfig.structureDefinitionDao(), this.daoConfig.structureDefinitionSnapshotDao(), this.daoConfig.codeSystemDao(), this.daoConfig.valueSetDao(), connection)));
        return validationSupport.populateCache(this.validationSupport().fetchAllConformanceResources());
    }
}

