/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.event.EventManager;
import dev.dsf.fhir.event.EventManagerImpl;
import dev.dsf.fhir.spring.config.AuthorizationConfig;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.ValidationConfig;
import dev.dsf.fhir.subscription.MatcherFactory;
import dev.dsf.fhir.subscription.WebSocketSubscriptionManager;
import dev.dsf.fhir.subscription.WebSocketSubscriptionManagerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventConfig {
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private AuthorizationConfig authorizationConfig;
    @Autowired
    private ValidationConfig validationConfig;

    @Bean
    public MatcherFactory matcherFactory() {
        HashMap<String, ResourceDao<? extends Resource>> daosByResourceName = new HashMap<String, ResourceDao<? extends Resource>>();
        this.put(daosByResourceName, this.daoConfig.binaryDao());
        this.put(daosByResourceName, this.daoConfig.bundleDao());
        this.put(daosByResourceName, this.daoConfig.codeSystemDao());
        this.put(daosByResourceName, this.daoConfig.documentReferenceDao());
        this.put(daosByResourceName, this.daoConfig.endpointDao());
        this.put(daosByResourceName, this.daoConfig.groupDao());
        this.put(daosByResourceName, this.daoConfig.healthcareServiceDao());
        this.put(daosByResourceName, this.daoConfig.libraryDao());
        this.put(daosByResourceName, this.daoConfig.locationDao());
        this.put(daosByResourceName, this.daoConfig.measureDao());
        this.put(daosByResourceName, this.daoConfig.measureReportDao());
        this.put(daosByResourceName, this.daoConfig.namingSystemDao());
        this.put(daosByResourceName, this.daoConfig.organizationAffiliationDao());
        this.put(daosByResourceName, this.daoConfig.organizationDao());
        this.put(daosByResourceName, this.daoConfig.patientDao());
        this.put(daosByResourceName, this.daoConfig.practitionerDao());
        this.put(daosByResourceName, this.daoConfig.practitionerRoleDao());
        this.put(daosByResourceName, this.daoConfig.provenanceDao());
        this.put(daosByResourceName, this.daoConfig.questionnaireDao());
        this.put(daosByResourceName, this.daoConfig.questionnaireResponseDao());
        this.put(daosByResourceName, this.daoConfig.researchStudyDao());
        this.put(daosByResourceName, this.daoConfig.structureDefinitionDao());
        this.put(daosByResourceName, this.daoConfig.subscriptionDao());
        this.put(daosByResourceName, this.daoConfig.taskDao());
        this.put(daosByResourceName, this.daoConfig.valueSetDao());
        return new MatcherFactory(daosByResourceName);
    }

    private void put(Map<String, ? super ResourceDao<? extends Resource>> daosByResourceName, ResourceDao<? extends Resource> dao) {
        daosByResourceName.put(dao.getResourceTypeName(), dao);
    }

    @Bean
    public EventManager eventManager() {
        List eventHandlers = Stream.of(this.validationConfig.validationSupport(), this.webSocketSubscriptionManager()).filter(o -> o instanceof EventHandler).map(o -> (EventHandler)o).collect(Collectors.toList());
        return new EventManagerImpl(eventHandlers);
    }

    @Bean
    public WebSocketSubscriptionManager webSocketSubscriptionManager() {
        return new WebSocketSubscriptionManagerImpl(this.daoConfig.daoProvider(), this.helperConfig.exceptionHandler(), this.matcherFactory(), this.fhirConfig.fhirContext(), this.authorizationConfig.authorizationRuleProvider());
    }

    @Bean
    public EventGenerator eventGenerator() {
        return new EventGenerator();
    }
}

