/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.RoleConfig;
import dev.dsf.common.auth.conf.RoleConfigReader;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.IdentityProviderImpl;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authentication.OrganizationProviderImpl;
import dev.dsf.fhir.authentication.PractitionerProvider;
import dev.dsf.fhir.authentication.PractitionerProviderImpl;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import java.util.List;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationConfig.class);
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public OrganizationProvider organizationProvider() {
        return new OrganizationProviderImpl(this.daoConfig.organizationDao(), this.helperConfig.exceptionHandler(), this.propertiesConfig.getOrganizationIdentifierValue());
    }

    @Bean
    public PractitionerProvider practitionerProvider() {
        List<String> configuredUserThumbprints = this.roleConfig().getEntries().stream().flatMap(e -> e.getThumbprints().stream()).distinct().toList();
        return new PractitionerProviderImpl(configuredUserThumbprints);
    }

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProviderImpl(this.organizationProvider(), this.practitionerProvider(), this.propertiesConfig.getOrganizationIdentifierValue(), this.roleConfig());
    }

    @Bean
    public RoleConfig roleConfig() {
        String roleConfig = this.propertiesConfig.getRoleConfig();
        if (roleConfig != null) {
            RoleConfig config = new RoleConfigReader().read(roleConfig, role -> FhirServerRole.isValid(role) ? FhirServerRole.valueOf(role) : null, this::practionerRoleFactory);
            logger.info("Role config: {}", (Object)config.toString());
            return config;
        }
        throw new RuntimeException("Roles not configured");
    }

    private Coding practionerRoleFactory(String role) {
        String[] roleParts;
        if (role != null && (roleParts = role.split("\\|")).length == 2) {
            return new Coding().setSystem(roleParts[0]).setCode(roleParts[1]);
        }
        return null;
    }
}

