/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.adapter.FhirAdapter;
import dev.dsf.fhir.adapter.HtmlFhirAdapter;
import dev.dsf.fhir.adapter.QuestionnaireResponseHtmlGenerator;
import dev.dsf.fhir.adapter.SearchBundleHtmlGenerator;
import dev.dsf.fhir.adapter.TaskHtmlGenerator;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdapterConfig {
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public FhirAdapter fhirAdapter() {
        return new FhirAdapter(this.fhirConfig.fhirContext());
    }

    @Bean
    public HtmlFhirAdapter htmlFhirAdapter() {
        return new HtmlFhirAdapter(this.fhirConfig.fhirContext(), () -> this.propertiesConfig.getServerBaseUrl(), List.of(new QuestionnaireResponseHtmlGenerator(), new TaskHtmlGenerator(), new SearchBundleHtmlGenerator(this.propertiesConfig.getDefaultPageCount())));
    }
}

