/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import dev.dsf.fhir.dao.CodeSystemDao;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.ValueSetDao;
import dev.dsf.fhir.function.SupplierWithSqlException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ValidationSupportWithFetchFromDbWithTransaction
implements IValidationSupport,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ValidationSupportWithFetchFromDbWithTransaction.class);
    private final FhirContext context;
    private final StructureDefinitionDao structureDefinitionDao;
    private final StructureDefinitionDao structureDefinitionSnapshotDao;
    private final CodeSystemDao codeSystemDao;
    private final ValueSetDao valueSetDao;
    private final Connection connection;

    public ValidationSupportWithFetchFromDbWithTransaction(FhirContext context, StructureDefinitionDao structureDefinitionDao, StructureDefinitionDao structureDefinitionSnapshotDao, CodeSystemDao codeSystemDao, ValueSetDao valueSetDao, Connection connection) {
        this.context = context;
        this.structureDefinitionDao = structureDefinitionDao;
        this.structureDefinitionSnapshotDao = structureDefinitionSnapshotDao;
        this.codeSystemDao = codeSystemDao;
        this.valueSetDao = valueSetDao;
        this.connection = connection;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.structureDefinitionDao, "structureDefinitionDao");
        Objects.requireNonNull(this.structureDefinitionSnapshotDao, "structureDefinitionSnapshotDao");
        Objects.requireNonNull(this.codeSystemDao, "codeSystemDao");
        Objects.requireNonNull(this.valueSetDao, "valueSetDao");
    }

    public FhirContext getFhirContext() {
        return this.context;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        return Stream.concat(this.throwRuntimeException(() -> this.codeSystemDao.readAllWithTransaction(this.connection)).stream(), Stream.concat(this.fetchAllStructureDefinitions().stream(), this.throwRuntimeException(() -> this.valueSetDao.readAllWithTransaction(this.connection)).stream())).collect(Collectors.toList());
    }

    public List<StructureDefinition> fetchAllStructureDefinitions() {
        HashMap byUrl = new HashMap();
        this.throwRuntimeException(() -> this.structureDefinitionSnapshotDao.readAllWithTransaction(this.connection)).forEach(s -> byUrl.put(s.getUrl(), s));
        this.throwRuntimeException(() -> this.structureDefinitionDao.readAllWithTransaction(this.connection)).forEach(s -> byUrl.putIfAbsent(s.getUrl(), s));
        return new ArrayList<StructureDefinition>(byUrl.values());
    }

    public StructureDefinition fetchStructureDefinition(String url) {
        Optional structureDefinition = null;
        structureDefinition = this.throwRuntimeException(() -> this.structureDefinitionSnapshotDao.readByUrlAndVersionWithTransaction(this.connection, url));
        if (structureDefinition.isPresent()) {
            return (StructureDefinition)structureDefinition.get();
        }
        structureDefinition = this.throwRuntimeException(() -> this.structureDefinitionDao.readByUrlAndVersionWithTransaction(this.connection, url));
        if (structureDefinition.isPresent()) {
            return (StructureDefinition)structureDefinition.get();
        }
        return null;
    }

    private <R> R throwRuntimeException(SupplierWithSqlException<R> reader) {
        try {
            return reader.get();
        }
        catch (SQLException e) {
            logger.warn("Error while accessing DB", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeSystem fetchCodeSystem(String url) {
        Optional codeSystem = this.throwRuntimeException(() -> this.codeSystemDao.readByUrlAndVersionWithTransaction(this.connection, url));
        if (codeSystem.isPresent()) {
            return (CodeSystem)codeSystem.get();
        }
        return null;
    }

    public ValueSet fetchValueSet(String url) {
        Optional valueSet = this.throwRuntimeException(() -> this.valueSetDao.readByUrlAndVersionWithTransaction(this.connection, url));
        if (valueSet.isPresent()) {
            return (ValueSet)valueSet.get();
        }
        return null;
    }
}

